package cn.com.duiba.galaxy.console.manager;

import cn.com.duiba.galaxy.console.model.param.template.TemplatePageQueryParam;
import cn.com.duiba.galaxy.console.model.param.template.TemplateSaveParam;
import cn.com.duiba.galaxy.console.model.param.template.TemplateSyncParam;
import cn.com.duiba.galaxy.console.model.vo.PageList;
import cn.com.duiba.galaxy.console.model.vo.template.TemplateVo;


/**
 * 模板管理
 *
 * @author fangxiaorun
 * @date 2022/09/30
 */
public interface TemplateBackendManager {
    /**
     * 通过模版id获取模版信息
     *
     * @param id id
     * @return {@link TemplateVo}
     */
    TemplateVo getById(Long id);

    /**
     * 查询模版列表
     *
     * @param param 模板查询参数
     * @return {@link PageList}<{@link TemplateVo}>
     */
    PageList<TemplateVo> list(TemplatePageQueryParam param);

    /**
     * 保存模版
     *
     * @param param 模板保存参数
     * @return {@link Boolean}
     */
    Boolean save(TemplateSaveParam param);

    /**
     * 同步模版
     *
     * @param param 模板同步参数
     * @return {@link Boolean}
     */
    Boolean sync(TemplateSyncParam param);
}
