package cn.com.duiba.galaxy.console.manager.impl;

import cn.com.duiba.galaxy.basic.enums.DeleteFieldTypeEnum;
import cn.com.duiba.galaxy.basic.model.entity.SpEntity;
import cn.com.duiba.galaxy.basic.service.SpService;
import cn.com.duiba.galaxy.console.manager.SpManager;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * @author zhangdaqing
 * @Date 2022/10/31 11:01
 **/
public abstract class AbstractSpManagerImpl implements SpManager {

    @Autowired
    protected SpService spService;

    @Override
    public List<SpEntity> listAllSps(Long prototypeId) {
        LambdaQueryWrapper<SpEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SpEntity::getDeleted, DeleteFieldTypeEnum.UN_DELETE.getCode()).eq(SpEntity::getPrototypeId, prototypeId);
        return spService.list(queryWrapper);
    }

    /**
     * 获取道具通过道具id
     *
     * @return {@link SpEntity}
     */
    @Override
    public SpEntity getSpBySpId(String spId, Long prototypeId) {
        LambdaQueryWrapper<SpEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SpEntity::getPrototypeId, prototypeId).eq(SpEntity::getSpId, spId);
        return spService.getOne(queryWrapper);
    }

}
