package cn.com.duiba.galaxy.console.manager.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.galaxy.adapter.base.adapter.PrizeAdapter;
import cn.com.duiba.galaxy.adapter.base.adapter.StockAdapter;
import cn.com.duiba.galaxy.adapter.base.dto.FailStockDto;
import cn.com.duiba.galaxy.adapter.base.dto.ProjectXItemDto;
import cn.com.duiba.galaxy.adapter.base.dto.UpdateStockDto;
import cn.com.duiba.galaxy.adapter.base.enums.AdapterTypeEnum;
import cn.com.duiba.galaxy.adapter.base.enums.ItemBizTypeEnum;
import cn.com.duiba.galaxy.adapter.base.handler.GalaxyAdapter;
import cn.com.duiba.galaxy.adapter.base.handler.GalaxyAdapterFactory;
import cn.com.duiba.galaxy.adapter.base.params.ItemListParam;
import cn.com.duiba.galaxy.basic.enums.DeleteFieldTypeEnum;
import cn.com.duiba.galaxy.basic.enums.OptionTypeEnum;
import cn.com.duiba.galaxy.basic.enums.PrizeTypeEnum;
import cn.com.duiba.galaxy.basic.model.entity.OptionEntity;
import cn.com.duiba.galaxy.basic.model.entity.PrizeEntity;
import cn.com.duiba.galaxy.basic.service.OptionService;
import cn.com.duiba.galaxy.basic.service.PrizeService;
import cn.com.duiba.galaxy.console.manager.OptionManager;
import cn.com.duiba.galaxy.console.model.param.OperationalOptionParam;
import cn.com.duiba.galaxy.core.enums.PlatformCoreErrorEnum;
import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * Created by hong
 * time 2022/10/29.
 */
@Service
public class OptionManagerImpl implements OptionManager {

    @Autowired
    private OptionService optionService;

    @Autowired
    private PrizeService prizeService;


    @Autowired
    private GalaxyAdapterFactory<GalaxyAdapter> galaxyAdapterFactory;


    @Override
    public Boolean operationalOption(OperationalOptionParam param) {
        return null;
    }

    /**
     * 批处理操作奖项
     *
     * @param operationalOptionParamList 操作奖项参数列表
     * @param updateStockDtos
     * @return {@link Boolean}
     */
    @Override
    public Boolean batchOperationalOption(Long appId, Long projectId, List<OperationalOptionParam> operationalOptionParamList, List<UpdateStockDto> updateStockDtos) throws BizException {

        // 需要把传过来的option 和库里的奖项做对比，多余的要逻辑删除
        StockAdapter stockAdapter = galaxyAdapterFactory.getAdapterByType(AdapterTypeEnum.CREDIT, "StockAdapter");
        List<OperationalOptionParam>                collect         = operationalOptionParamList.stream()
                                                                                                .filter(a -> Objects.isNull(a.getId()))
                                                                                                .collect(Collectors.toList());
        List<OperationalOptionParam>                updateOption    = operationalOptionParamList.stream()
                                                                                                 .filter(a -> Objects.nonNull(a.getId()))
                                                                                                 .collect(Collectors.toList());
        Map<String, List<OperationalOptionParam>>   itemIdToMap     = operationalOptionParamList.stream()
                                                                                                 .filter(o -> Objects.equals(o.getOptionType(), OptionTypeEnum.PROCUREMENT.getCode()))
                                                                                                 .collect(Collectors.groupingBy(o -> o.getItemId() + o.getBizType()));
        Map<String, Integer>                        creditItemStock = operationalOptionParamList.stream()
                                                                                                .filter(o -> Objects.equals(o.getOptionType(), OptionTypeEnum.PROCUREMENT.getCode())
                                                                                                         && Objects.equals(o.getBizType(), ItemBizTypeEnum.CREDIT.getCode()))
                                                                                                .collect(Collectors.groupingBy(OperationalOptionParam::getItemId, Collectors.summingInt(OperationalOptionParam::getTotalStock)));
        Map<String, Integer>                        ownItemStock    = operationalOptionParamList.stream()
                                                                                                .filter(o -> Objects.equals(o.getOptionType(), OptionTypeEnum.PROCUREMENT.getCode())
                                                                                                        && Objects.equals(o.getBizType(), ItemBizTypeEnum.OWN.getCode()))
                                                                                                .collect(Collectors.groupingBy(OperationalOptionParam::getItemId, Collectors.summingInt(OperationalOptionParam::getTotalStock)));
        List<OptionEntity>                          optionEntities2 = BeanUtils.copyList(updateOption, OptionEntity.class);
        Map<Long, Integer>                          prizeOption     = new HashMap<>();
        List<OptionEntity>                          oldOption       = optionService.lambdaQuery()
                                                                                   .eq(OptionEntity::getProjectId, projectId)
                                                                                   .eq(OptionEntity::getDeleted, DeleteFieldTypeEnum.UN_DELETE.getCode())
                                                                                   .list();


        if (CollectionUtils.isNotEmpty(optionEntities2)) {
            prizeOption = oldOption.stream()
                                   .filter(o -> Objects.equals(o.getOptionType(), OptionTypeEnum.PROCUREMENT.getCode()))
                                   .collect(Collectors.groupingBy(OptionEntity::getPrizeId, Collectors.summingInt(OptionEntity::getTotalStock)));
        }
        Map<Long, Integer> finalPrizeOption    = prizeOption;
        Map<String, Long>  itemIdTypeToPrizeId = new HashMap<>();

        handlePrize(appId, updateStockDtos, creditItemStock, finalPrizeOption, itemIdTypeToPrizeId, ItemBizTypeEnum.CREDIT.getCode());

        handlePrize(appId, updateStockDtos, ownItemStock, finalPrizeOption, itemIdTypeToPrizeId, ItemBizTypeEnum.OWN.getCode());

        //新增奖项处理
        List<OptionEntity> optionEntities = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(collect)) {
            collect.forEach(o -> {
                if (StringUtils.isNumeric(o.getItemId())) {
                    o.setPrizeId(itemIdTypeToPrizeId.getOrDefault(o.getItemId() + o.getBizType(), 0L));
                }
            });
            optionEntities = BeanUtils.copyList(collect, OptionEntity.class);
        }
        //修改奖项处理
        if (CollectionUtils.isNotEmpty(updateOption)) {
            handleUpdateOption(operationalOptionParamList, updateStockDtos, updateOption, oldOption, itemIdTypeToPrizeId, optionEntities);
        } else {
            handleAllDelOption(updateStockDtos, oldOption, optionEntities);
        }
        //处理积分商城库存
        handleStock(appId, updateStockDtos, stockAdapter, itemIdToMap);
        if (CollectionUtils.isNotEmpty(optionEntities)) {
            optionService.saveOrUpdateBatch(optionEntities);
        }
        return true;
    }

    /**
     * 处理奖品以及奖品库存
     * @param appId
     * @param updateStockDtos
     * @param itemStock
     * @param finalPrizeOption
     * @param itemIdTypeToPrizeId
     * @param bizType
     */
    private void handlePrize(Long appId, List<UpdateStockDto> updateStockDtos, Map<String, Integer> itemStock, Map<Long, Integer> finalPrizeOption, Map<String, Long> itemIdTypeToPrizeId, Integer bizType) {
        Set<String> itemIds = itemStock.keySet();
        if (CollectionUtils.isEmpty(itemIds)) {
            return;
        }
        Set<Long> collect4 = itemIds.stream().map(c -> {
            if (StringUtils.isNumeric(c)) {
                return Long.valueOf(c);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        List<PrizeEntity> prizeEntities = null;
        if (CollectionUtils.isNotEmpty(collect4)) {
            prizeEntities = prizeService.lambdaQuery()
                                        .eq(PrizeEntity::getThirdAppId, appId)
                                        .in(CollectionUtils.isNotEmpty(collect4), PrizeEntity::getRefId, collect4)
                                        .eq(PrizeEntity::getSource, bizType)
                                        .eq(PrizeEntity::getDeleted, DeleteFieldTypeEnum.UN_DELETE.getCode())
                                        .list();
        }

        if (CollectionUtils.isNotEmpty(prizeEntities)) {
            Map<String, Long> collect2 = prizeEntities.stream().collect(Collectors.toMap(p -> p.getRefId()
                                                                                               .toString() + p.getSource(), PrizeEntity::getId));
            itemIdTypeToPrizeId.putAll(collect2);
            List<Long> collect10 = prizeEntities.stream().map(PrizeEntity::getRefId).collect(Collectors.toList());

            prizeEntities.forEach(c -> {
                //todo 防并发
                Integer integer = itemStock.get(c.getRefId().toString());
                if (Objects.isNull(integer) || integer < 0) {
                    return;
                }
                Integer oldStock = finalPrizeOption.getOrDefault(c.getId(), 0);
                Long    l        = (Objects.nonNull(c.getUsedStock()) ? c.getUsedStock() : 0) - oldStock + integer;
                if ((Objects.nonNull(c.getTotalStock()) ? c.getTotalStock() : 0) > l) {
                    prizeService.lambdaUpdate()
                                .set(PrizeEntity::getTotalStock, l)
                                .set(PrizeEntity::getUsedStock, l)
                                .eq(PrizeEntity::getThirdAppId, appId)
                                .eq(PrizeEntity::getRefId, c.getRefId())
                                .eq(PrizeEntity::getSource, bizType)
                                .eq(PrizeEntity::getDeleted, DeleteFieldTypeEnum.UN_DELETE.getCode())
                                .update();
                    // 退三方库存
                        UpdateStockDto stockDto = new UpdateStockDto();
                        stockDto.setType(UpdateStockDto.INCREASE);
                        stockDto.setNum((Objects.nonNull(c.getTotalStock()) ? c.getTotalStock() : 0) - l);
                        if(Objects.equals(bizType,ItemBizTypeEnum.CREDIT.getCode())){
                            stockDto.setItemId(c.getRefId());
                        }else if(Objects.equals(bizType,ItemBizTypeEnum.OWN.getCode())){
                            stockDto.setAppItemId(c.getRefId());
                        }
                        updateStockDtos.add(stockDto);
                }
                if ((Objects.nonNull(c.getTotalStock()) ? c.getTotalStock() : 0) < l) {
                    prizeService.lambdaUpdate()
                                .set(PrizeEntity::getUsedStock, l)
                                .set(PrizeEntity::getTotalStock, l)
                                .eq(PrizeEntity::getThirdAppId, appId)
                                .eq(PrizeEntity::getRefId, c.getRefId())
                                .eq(PrizeEntity::getSource, bizType)
                                .eq(PrizeEntity::getDeleted, DeleteFieldTypeEnum.UN_DELETE.getCode())
                                .update();
                        UpdateStockDto stockDto = new UpdateStockDto();
                        stockDto.setType(UpdateStockDto.DEDUCT);
                        stockDto.setNum(l - (Objects.nonNull(c.getTotalStock()) ? c.getTotalStock() : 0));
                        if (Objects.equals(bizType, ItemBizTypeEnum.CREDIT.getCode())) {
                            stockDto.setItemId(c.getRefId());
                        } else if (Objects.equals(bizType, ItemBizTypeEnum.OWN.getCode())) {
                            stockDto.setAppItemId(c.getRefId());
                        }
                        updateStockDtos.add(stockDto);
                }
            });

            collect10.forEach(collect4::remove);
        }

        collect4.forEach(f -> {
            Integer integer = itemStock.get(f.toString());
            if (Objects.isNull(integer) || integer <= 0) {
                return;
            }
            UpdateStockDto stockDto = new UpdateStockDto();
            stockDto.setType(UpdateStockDto.DEDUCT);
            stockDto.setNum(integer.longValue());
            if(Objects.equals(bizType,ItemBizTypeEnum.CREDIT.getCode())){
                stockDto.setItemId(f);
            }else if(Objects.equals(bizType,ItemBizTypeEnum.OWN.getCode())){
                stockDto.setAppItemId(f);
            }
            updateStockDtos.add(stockDto);
        });


        PrizeAdapter      prizeAdapter = galaxyAdapterFactory.getAdapterByType(AdapterTypeEnum.CREDIT, "PrizeAdapter");
        List<PrizeEntity> collect2     = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(collect4)) {
            ItemListParam i = new ItemListParam();
            i.setPageNo(1);
            i.setPageSize(100);
            i.setItemIds(new ArrayList<>(collect4));
            i.setBizType(bizType);
            i.setBizId(appId);
            List<ProjectXItemDto> projectXItemDtos = prizeAdapter.itemList(i);
            if(CollectionUtils.isNotEmpty(projectXItemDtos)){
                collect2 = projectXItemDtos.stream().map(p -> {
                    Long        itemId           = Objects.nonNull(p.getItemId()) ? p.getItemId()
                                                                             : (Objects.nonNull(p.getAppItemId())
                                                                                ? p.getAppItemId() : 0);
                    PrizeEntity prizeEntity = new PrizeEntity();
                    prizeEntity.setPrizeImg(p.getIcon());
                    prizeEntity.setSource(bizType);
                    prizeEntity.setRefId(itemId);
                    prizeEntity.setPrizeName(p.getItemName());
                    prizeEntity.setTotalStock(itemStock.getOrDefault(itemId.toString(), 0).longValue());
                    prizeEntity.setUsedStock(itemStock.getOrDefault(itemId.toString(), 0).longValue());
                    prizeEntity.setRefType(p.getItemType());
                    prizeEntity.setThirdAppId(appId);
                    prizeEntity.setPrizeType(PrizeTypeEnum.getByType(p.getItemType()).getCode());

                    return prizeEntity;
                }).collect(Collectors.toList());
            }
        }

        if (CollectionUtils.isNotEmpty(collect2)) {
            boolean b = prizeService.saveBatch(collect2);
            itemIdTypeToPrizeId.putAll(collect2.stream()
                                               .collect(Collectors.toMap(p -> p.getRefId()
                                                                               .toString() + p.getSource(), PrizeEntity::getId)));
        }

    }



    /**
     * 处理更新的奖项
     * @param operationalOptionParamList
     * @param updateStockDtos
     * @param updateOption
     * @param oldOption
     * @param itemIdTypeToPrizeId
     * @param optionEntities
     */
    private void handleUpdateOption(List<OperationalOptionParam> operationalOptionParamList, List<UpdateStockDto> updateStockDtos, List<OperationalOptionParam> updateOption, List<OptionEntity> oldOption, Map<String, Long> itemIdTypeToPrizeId, List<OptionEntity> optionEntities) {
        updateOption.forEach(o -> {
            if (StringUtils.isNumeric(o.getItemId())) {
                o.setPrizeId(itemIdTypeToPrizeId.getOrDefault(o.getItemId() + o.getBizType(), 0L));
            }
        });
        List<OptionEntity> optionEntities1 = BeanUtils.copyList(updateOption, OptionEntity.class);
        List<Long>         collect5        = optionEntities1.stream()
                                                            .map(OptionEntity::getPrizeId)
                                                            .collect(Collectors.toList());

        List<Long> updatePrizedOption = oldOption.stream()
                                                 .filter(o -> Objects.equals(o.getOptionType(), OptionTypeEnum.PROCUREMENT.getCode()))
                                                 .filter(a -> operationalOptionParamList.stream()
                                                                         .filter(o -> Objects.equals(o.getOptionType(), OptionTypeEnum.PROCUREMENT.getCode()))
                                                                         .anyMatch(b -> Objects.equals(a.getId(), b.getId()) && !Objects.equals(a.getPrizeId(), b.getPrizeId())))
                                                 .map(OptionEntity::getPrizeId)
                                                 .collect(Collectors.toList());

        List<OptionEntity> delPrizes = new ArrayList<>();
        List<OptionEntity> collect6 = oldOption.stream()
                                               .filter(a -> optionEntities1.stream()
                                                                      .noneMatch(b -> Objects.equals(a.getId(), b.getId())))
                                               .map(c -> {
                                              if (!collect5.contains(c.getPrizeId())) {
                                                  delPrizes.add(c);
                                              }
                                              OptionEntity e = new OptionEntity();
                                              e.setId(c.getId());
                                              e.setDeleted(1);
                                              return e;
                                          })
                                               .collect(Collectors.toList());
        handleDelPrize(updateStockDtos, updatePrizedOption, delPrizes);

        List<OptionEntity> collect7 = optionEntities1.stream()
                                                     .filter(a -> collect6.stream()
                                                                          .noneMatch(c -> Objects.equals(a.getId(), c.getId())))
                                                     .collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect6)) {
            optionEntities.addAll(collect6);
        }


        if (CollectionUtils.isNotEmpty(collect7)) {
            optionEntities.addAll(collect7);
        }
    }

    /**
     * 处理删除奖品的库存
     * @param updateStockDtos
     * @param updatePrizedOption
     * @param delPrizes
     */
    private void handleDelPrize(List<UpdateStockDto> updateStockDtos, List<Long> updatePrizedOption, List<OptionEntity> delPrizes) {
        List<Long> prizeIds = delPrizes.stream().map(OptionEntity::getPrizeId).collect(Collectors.toList());
        Map<Long, Integer> collect2 = delPrizes.stream()
                                               .filter(o -> Objects.equals(o.getOptionType(), OptionTypeEnum.PROCUREMENT.getCode()))
                                               .collect(Collectors.groupingBy(OptionEntity::getPrizeId, Collectors.summingInt(OptionEntity::getTotalStock)));
        prizeIds.addAll(updatePrizedOption);
        if (CollectionUtils.isEmpty(prizeIds)) {
            return;
        }
        List<PrizeEntity> list2 = prizeService.lambdaQuery()
                                              .in(CollectionUtils.isNotEmpty(prizeIds), PrizeEntity::getId, prizeIds)
                                              .eq(PrizeEntity::getDeleted, DeleteFieldTypeEnum.UN_DELETE.getCode())
                                              .list();
        if (CollectionUtils.isNotEmpty(list2)) {
            List<PrizeEntity> prizeEntities = list2.stream().map(l -> {
                if (Objects.isNull(l.getTotalStock())) {
                    return null;
                }
                PrizeEntity prizeEntity = new PrizeEntity();
                prizeEntity.setId(l.getId());
                prizeEntity.setTotalStock(l.getTotalStock() - collect2.getOrDefault(l.getId(), 0));
                prizeEntity.setUsedStock(l.getUsedStock() - collect2.getOrDefault(l.getId(), 0));
                if(Objects.equals(l.getTotalStock(),0L)){
                    return prizeEntity;
                }
                UpdateStockDto stockDto = new UpdateStockDto();
                stockDto.setType(UpdateStockDto.INCREASE);
                stockDto.setNum(l.getTotalStock());
                if (Objects.equals(l.getSource(), ItemBizTypeEnum.CREDIT.getCode())) {
                    stockDto.setItemId(l.getRefId());
                } else if (Objects.equals(l.getSource(), ItemBizTypeEnum.OWN.getCode())) {
                    stockDto.setAppItemId(l.getRefId());
                }

                updateStockDtos.add(stockDto);

                return prizeEntity;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            prizeService.updateBatchById(prizeEntities);
        }
    }

    /**
     * 处理删除所有奖项的情况
     * @param updateStockDtos
     * @param oldOption
     * @param optionEntities
     */
    private void handleAllDelOption(List<UpdateStockDto> updateStockDtos, List<OptionEntity> oldOption, List<OptionEntity> optionEntities) {
        List<OptionEntity> collect6 = oldOption.stream().map(c -> {
            OptionEntity e = new OptionEntity();
            e.setId(c.getId());
            e.setDeleted(1);
            return e;
        }).collect(Collectors.toList());
        handleDelPrize(updateStockDtos, new ArrayList<>(), oldOption);
        if (CollectionUtils.isNotEmpty(collect6)) {
            return;
        }
        optionEntities.addAll(collect6);
    }

    /**
     * 将库存同步到三方
     * @param appId
     * @param updateStockDtos
     * @param stockAdapter
     * @param itemIdToMap
     * @throws BizException
     */
    private void handleStock(Long appId, List<UpdateStockDto> updateStockDtos, StockAdapter stockAdapter, Map<String, List<OperationalOptionParam>> itemIdToMap) throws BizException {
        if (CollectionUtils.isEmpty(updateStockDtos)) {
            return;
        }
        List<FailStockDto> failStockDtos = stockAdapter.batchDeductStock(appId.toString(), updateStockDtos);
        if (CollectionUtils.isEmpty(failStockDtos)) {
            return;
        }
        List<String> names = new ArrayList<>();
        failStockDtos.forEach(f -> {
            List<OperationalOptionParam> ps = itemIdToMap.getOrDefault(f.getItemId() + ItemBizTypeEnum.CREDIT.getCode()
                                                                                                             .toString(), itemIdToMap.getOrDefault(f.getAppItemId() + ItemBizTypeEnum.OWN.getCode()
                                                                                                                                                                                         .toString(), null));
            if (CollectionUtils.isEmpty(ps)) {
                return;
            }
            names.addAll(ps.stream().map(OperationalOptionParam::getOptionName).collect(Collectors.toList()));
        });

        throw new BizRuntimeException(PlatformCoreErrorEnum.PRIZE_STOCK_NOT_ENOUGH.setDesc(String.format("奖品[%s]库存操作失败", names)));
    }

    @Override
    public List<OptionEntity> listOptionByRuIds(Long projectId, List<String> ruIds) {
        LambdaQueryWrapper<OptionEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(OptionEntity::getProjectId, projectId)
                    .eq(OptionEntity::getDeleted, DeleteFieldTypeEnum.UN_DELETE.getCode());
        return optionService.list(queryWrapper);
    }

    @Override
    public Boolean batchDelOptions(Long projectId, List<OptionEntity> entities) {
        if (CollectionUtils.isNotEmpty(entities)) {
            entities.forEach(u -> u.setDeleted(DeleteFieldTypeEnum.DELETE.getCode()));
        }
        return optionService.updateBatchById(entities);
    }

    @Override
    public List<OptionEntity> listAllOptions(Long projectId) {
        LambdaQueryWrapper<OptionEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(OptionEntity::getProjectId, projectId)
                    .eq(OptionEntity::getDeleted, DeleteFieldTypeEnum.UN_DELETE.getCode());
        return optionService.list(queryWrapper);
    }
}
/**
 * noUpdatePrizeOption = list.stream()
 *                                       .filter(o -> Objects.equals(o.getOptionType(), OptionTypeEnum.PROCUREMENT.getCode()))
 *                                       .filter(a -> operationalOptionParamList.stream()
 *                                                                              .filter(o -> Objects.equals(o.getOptionType(), OptionTypeEnum.PROCUREMENT.getCode()))
 *                                                                              .anyMatch(b -> Objects.equals(a.getId(), b.getId())
 *                                                                                      && Objects.equals(a.getPrizeId(), b.getPrizeId())
 *                                                                                      && Objects.equals(a.getTotalStock(), b.getTotalStock())))
 *                                       .collect(Collectors.groupingBy(OptionEntity::getPrizeId, Collectors.summingInt(OptionEntity::getTotalStock)));
 *
 *             updatePrizeOption = list.stream()
 *                                     .filter(o -> Objects.equals(o.getOptionType(), OptionTypeEnum.PROCUREMENT.getCode()))
 *                                     .map(a -> {
 *                                         final OptionEntity[] optionEntity = {null};
 *                                         operationalOptionParamList.stream()
 *                                                                   .filter(o -> Objects.equals(o.getOptionType(), OptionTypeEnum.PROCUREMENT.getCode()))
 *                                                                   .forEach(b -> {
 *                                                                       if (Objects.equals(a.getId(), b.getId())
 *                                                                               && Objects.equals(a.getPrizeId(), b.getPrizeId())
 *                                                                               && !Objects.equals(a.getTotalStock(), b.getTotalStock())) {
 *                                                                           optionEntity[0] = new OptionEntity();
 *                                                                           optionEntity[0].setPrizeId(a.getPrizeId());
 *                                                                           optionEntity[0].setTotalStock((Objects.nonNull(b.getTotalStock())
 *                                                                                                          ? b.getTotalStock()
 *                                                                                                          : 0) - (
 *                                                                                   Objects.nonNull(a.getTotalStock())
 *                                                                                   ? a.getTotalStock() : 0));
 *
 *                                                                       }
 *                                                                   });
 *                                         return optionEntity[0];
 *                                     })
 *                                     .filter(Objects::nonNull)
 *                                     .collect(Collectors.groupingBy(OptionEntity::getPrizeId, Collectors.summingInt(OptionEntity::getTotalStock)));
 *
 *                                     Map<Long, Integer> addPrizeOption = list.stream()
 *                                                         .filter(o -> Objects.equals(o.getOptionType(), OptionTypeEnum.PROCUREMENT.getCode()))
 *                                                         .filter(a -> operationalOptionParamList.stream()
 *                                                                                                .filter(o -> Objects.equals(o.getOptionType(), OptionTypeEnum.PROCUREMENT.getCode()))
 *                                                                                                .anyMatch(b -> Objects.isNull(b.getId()) && Objects.equals(a.getPrizeId(), collect2.get(b.getItemId() + b.getBizType()))))
 *                                                         .collect(Collectors.groupingBy(OptionEntity::getPrizeId, Collectors.summingInt(OptionEntity::getTotalStock)));
 *
 *                                                         Map<Long, Integer> addPrizeOption = list.stream()
 *                                                         .filter(o -> Objects.equals(o.getOptionType(), OptionTypeEnum.PROCUREMENT.getCode()))
 *                                                         .filter(a -> operationalOptionParamList.stream()
 *                                                                                                .filter(o -> Objects.equals(o.getOptionType(), OptionTypeEnum.PROCUREMENT.getCode()))
 *                                                                                                .anyMatch(b -> Objects.isNull(b.getId()) && Objects.equals(a.getPrizeId(), collect2.get(b.getItemId() + b.getBizType()))))
 *                                                         .collect(Collectors.groupingBy(OptionEntity::getPrizeId, Collectors.summingInt(OptionEntity::getTotalStock)));
 *
 *
 *
 *
 *
 * private void handleOwnPrize(Long appId, List<UpdateStockDto> updateStockDtos, Map<String, Integer> ownItemStock, Map<Long, Integer> finalPrizeOption, Map<String, Long> collect3) {
 *         Set<String> itemIds1 = ownItemStock.keySet();
 *         if (CollectionUtils.isNotEmpty(itemIds1)) {
 *             Set<Long> collect4 = itemIds1.stream().map(c -> {
 *                 if (StringUtils.isNumeric(c)) {
 *                     return Long.valueOf(c);
 *                 }
 *                 return null;
 *             }).filter(Objects::nonNull).collect(Collectors.toSet());
 *             List<PrizeEntity> prizeEntities = null;
 *             if (CollectionUtils.isNotEmpty(collect4)) {
 *                 prizeEntities = prizeService.lambdaQuery()
 *                                             .eq(PrizeEntity::getThirdAppId, appId)
 *                                             .in(CollectionUtils.isNotEmpty(collect4), PrizeEntity::getRefId, collect4)
 *                                             .eq(PrizeEntity::getSource, ItemBizTypeEnum.OWN.getCode())
 *                                             .eq(PrizeEntity::getDeleted, DeleteFieldTypeEnum.UN_DELETE.getCode())
 *                                             .list();
 *             }
 *
 *
 *             if (CollectionUtils.isNotEmpty(prizeEntities)) {
 *                 Map<String, Long> collect2 = prizeEntities.stream().collect(Collectors.toMap(p -> p.getRefId()
 *                                                                                                    .toString() + p.getSource(), PrizeEntity::getId));
 *                 collect3.putAll(collect2);
 *
 *
 *                 List<Long> collect10 = prizeEntities.stream().map(PrizeEntity::getRefId).collect(Collectors.toList());
 *                 prizeEntities.forEach(c -> {
 *                     Integer integer = ownItemStock.get(c.getRefId().toString());
 *                     if (Objects.isNull(integer) || integer < 0) {
 *                         return;
 *                     }
 *
 *                     Integer oldStock      = finalPrizeOption.getOrDefault(c.getId(), 0);
 *
 *                     Long l = (Objects.nonNull(c.getUsedStock()) ? c.getUsedStock() : 0) - oldStock + integer;
 *
 *                     if ((Objects.nonNull(c.getTotalStock()) ? c.getTotalStock() : 0) > l) {
 *                         prizeService.lambdaUpdate()
 *                                     .set(PrizeEntity::getTotalStock, l)
 *                                     .set(PrizeEntity::getUsedStock, l)
 *                                     .eq(PrizeEntity::getThirdAppId, appId)
 *                                     .eq(PrizeEntity::getRefId, c.getRefId())
 *                                     .eq(PrizeEntity::getSource, ItemBizTypeEnum.OWN.getCode())
 *                                     .eq(PrizeEntity::getDeleted, DeleteFieldTypeEnum.UN_DELETE.getCode())
 *                                     .update();
 *                         // 退三方库存
 *                         UpdateStockDto stockDto = new UpdateStockDto();
 *                         stockDto.setType(UpdateStockDto.INCREASE);
 *                         stockDto.setNum((Objects.nonNull(c.getTotalStock()) ? c.getTotalStock() : 0) - l);
 *                         stockDto.setAppItemId(c.getRefId());
 *                         updateStockDtos.add(stockDto);
 *                     }
 *                     if ((Objects.nonNull(c.getTotalStock()) ? c.getTotalStock() : 0) < l) {
 *                         UpdateStockDto stockDto = new UpdateStockDto();
 *                         stockDto.setType(UpdateStockDto.DEDUCT);
 *                         stockDto.setNum(l - (Objects.nonNull(c.getTotalStock()) ? c.getTotalStock() : 0));
 *                         stockDto.setAppItemId(c.getRefId());
 *                         updateStockDtos.add(stockDto);
 *                         prizeService.lambdaUpdate()
 *                                     .set(PrizeEntity::getUsedStock, l)
 *                                     .set(PrizeEntity::getTotalStock, l)
 *                                     .eq(PrizeEntity::getThirdAppId, appId)
 *                                     .eq(PrizeEntity::getRefId, c.getRefId())
 *                                     .eq(PrizeEntity::getSource, ItemBizTypeEnum.OWN.getCode())
 *                                     .eq(PrizeEntity::getDeleted, DeleteFieldTypeEnum.UN_DELETE.getCode())
 *                                     .update();
 *
 *                     }
 *                 });
 *
 *                 collect10.forEach(collect4::remove);
 *             }
 *
 *             collect4.forEach(f -> {
 *                 Integer integer = ownItemStock.get(f.toString());
 *                 if (Objects.isNull(integer) || integer <= 0) {
 *                     return;
 *                 }
 *                 UpdateStockDto stockDto = new UpdateStockDto();
 *                 stockDto.setType(UpdateStockDto.DEDUCT);
 *                 stockDto.setNum(integer.longValue());
 *                 stockDto.setAppItemId(f);
 *                 updateStockDtos.add(stockDto);
 *             });
 *
 *
 *             PrizeAdapter      prizeAdapter = galaxyAdapterFactory.getAdapterByType(AdapterTypeEnum.CREDIT, "PrizeAdapter");
 *             List<PrizeEntity> collect2     = new ArrayList<>();
 *             if (CollectionUtils.isNotEmpty(collect4)) {
 *                 ItemListParam i = new ItemListParam();
 *                 i.setPageNo(1);
 *                 i.setPageSize(100);
 *                 i.setItemIds(new ArrayList<>(collect4));
 *                 i.setBizType(ItemBizTypeEnum.OWN.getCode());
 *                 i.setBizId(appId);
 *                 List<RemoteProjectXItemDto> projectXItemDtos = prizeAdapter.itemList(i);
 *
 *                 collect2 = projectXItemDtos.stream().map(p -> {
 *                     PrizeEntity prizeEntity = new PrizeEntity();
 *                     prizeEntity.setPrizeImg(p.getIcon());
 *                     prizeEntity.setSource(ItemBizTypeEnum.OWN.getCode());
 *                     prizeEntity.setRefId(p.getAppItemId());
 *                     prizeEntity.setPrizeName(p.getItemName());
 *                     prizeEntity.setTotalStock(ownItemStock.getOrDefault(p.getAppItemId().toString(), 0).longValue());
 *                     prizeEntity.setUsedStock(ownItemStock.getOrDefault(p.getAppItemId().toString(), 0).longValue());
 *                     prizeEntity.setRefType(p.getItemType());
 *                     prizeEntity.setThirdAppId(p.getAppId());
 *                     prizeEntity.setPrizeType(PrizeTypeEnum.getByType(p.getItemType()).getCode());
 *
 *                     return prizeEntity;
 *                 }).collect(Collectors.toList());
 *             }
 *
 *             if (CollectionUtils.isNotEmpty(collect2)) {
 *                 boolean b = prizeService.saveBatch(collect2);
 *                 Map<String, Long> collect5 = collect2.stream().collect(Collectors.toMap(p -> p.getRefId()
 *                                                                                               .toString() + p.getSource(), PrizeEntity::getId));
 *                 collect3.putAll(collect5);
 *             }
 *
 *
 *         }
 *     }
 */