package cn.com.duiba.galaxy.console.manager.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.galaxy.console.enums.PlatformConsoleErrorEnum;
import cn.com.duiba.galaxy.console.manager.SsoExtManager;
import cn.com.duiba.galaxy.console.model.vo.admin.AdminVo;
import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;
import cn.com.duiba.galaxy.sdk.utils.Conditions;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.LoginStateDto;
import cn.com.duiba.sso.api.remoteservice.RemoteAdminService;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.hutool.core.bean.BeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;


/**
 * SSO扩展实现
 *
 * @author fangxiaorun
 * @date 2022/11/05
 */
@Slf4j
@Service
public class SsoExtManagerImpl implements SsoExtManager {

    @Resource
    private RemoteSSOService remoteSSOService;
    @Resource
    private RemoteAdminService remoteAdminService;

//    private static LoadingCache cache = Caffeine.newBuilder()
//            //最大个数限制
//            .maximumSize(2000L)
//            //初始化容量
//            .initialCapacity(100)
//            //访问后过期（包括读和写）
//            .expireAfterAccess(2, TimeUnit.DAYS)
//            //写后过期
//            .expireAfterWrite(2, TimeUnit.HOURS)
//            //写后自动异步刷新
//            .refreshAfterWrite(1, TimeUnit.HOURS)
//            //记录下缓存的一些统计数据，例如命中率等
//            .recordStats()
//            //cache对缓存写的通知回调
//            .writer(new CacheWriter() {
//                @Override
//                public void write(@NonNull Object key, @NonNull Object value) {
//                    log.info("key={}, CacheWriter write", key);
//                }
//
//                @Override
//                public void delete(@NonNull Object key, @Nullable Object value, @NonNull RemovalCause cause) {
//                    log.info("key={}, cause={}, CacheWriter delete", key, cause);
//                }
//            })
//            //使用CacheLoader创建一个LoadingCache
//            .build(new CacheLoader() {
//                //同步加载数据
//                @Nullable
//                @Override
//                public String load(@NonNull String key) throws Exception {
//                    return "value_" + key;
//                }
//
//                //异步加载数据
//                @Nullable
//                @Override
//                public String reload(@NonNull String key, @NonNull String oldValue) throws Exception {
//                    return "value_" + key;
//                }
//            });

    @Override
    public AdminVo getAdminInfo() {
        String ssoTicket = RequestTool.getCookie("sso_ticket");
        LoginStateDto loginStateDto = remoteSSOService.verifyTicket(ssoTicket);
        Conditions.expectNotNull(loginStateDto, PlatformConsoleErrorEnum.SSO_LOGIN_VERIFY_FAIL);
        AdminDto admin;
        try {
            admin = remoteAdminService.findOneAdmin(loginStateDto.getAdminId());
        } catch (BizException e) {
            throw new BizRuntimeException(PlatformConsoleErrorEnum.THE_EMPLOYEE_HAS_LEFT);
        }
        return BeanUtil.copyProperties(admin, AdminVo.class);
    }
}
