package cn.com.duiba.galaxy.console.manager.impl.credits;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.jiuli.client.JiuliFileClient;
import cn.com.duiba.cloud.jiuli.client.domian.params.PutFileParams;
import cn.com.duiba.cloud.jiuli.client.domian.result.PutFileResult;
import cn.com.duiba.cloud.jiuli.client.service.JiuliFileClientManager;
import cn.com.duiba.galaxy.console.config.OssConfig;
import cn.com.duiba.galaxy.console.enums.PlatformConsoleErrorEnum;
import cn.com.duiba.galaxy.console.manager.FileUploadManager;
import cn.com.duiba.galaxy.console.util.FileIDGeneratorUtils;
import cn.com.duiba.galaxy.core.annotation.ConditionalOnBizScene;
import cn.com.duiba.galaxy.core.enums.BizSceneEnum;
import cn.com.duiba.galaxy.sdk.utils.Conditions;
import cn.com.duiba.wolf.utils.DateUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.Date;

/**
 * 积分商城1.0 文件上传功能
 *
 * @author zhangdaqing
 * @Date 2022/10/11 10:15
 **/
@Service
@Slf4j
@ConditionalOnBizScene(BizSceneEnum.CREDITS_MALL_V1)
public class CreditsFileUploadManagerImpl implements FileUploadManager {
    @Autowired
    private OssConfig ossConfig;
    /**
     * 文件上传支持大小（单位：M）
     */
    private static final int MAX_M = 20;

    /**
     * 业务系统文件目录
     */
    private static final String DUIBA_GALAXY_CONSOLE = "duibaGalaxyConsole";

    @Resource
    private JiuliFileClientManager jiuliFileClientManager;


    @Override
    public String uploadFile(MultipartFile file) throws IOException, BizException {

        // 校验文件大小
        Conditions.expectTrue(checkFileSize(file.getSize(), MAX_M, "M"), PlatformConsoleErrorEnum.FILE_SIZE_LIMIT);

        //  校验文件名
        String originalFilename = file.getOriginalFilename();
        Conditions.expectNotNull(originalFilename, PlatformConsoleErrorEnum.FILE_TYPE_NULL_ERROR);

        //  文件上传格式校验
        String fileType = originalFilename.substring(originalFilename.lastIndexOf('.') + 1);
        //Conditions.expectTrue(IMAGE_TYPE.contains(fileType), PlatformConsoleErrorEnum.FILE_ILLEGAL_FORMAT_ERROR);

        String fileName = FileIDGeneratorUtils.getRandomString(10) + "." + fileType;
        String dateStr = DateUtils.getDayStr(new Date());
        String path = String.format(DUIBA_GALAXY_CONSOLE + "/%s/%s", dateStr, fileName);

        // TODO 空间表示后续应该做动态配置
        JiuliFileClient client = jiuliFileClientManager.getFileClient(ossConfig.getSpaceKey());
        PutFileParams putFileParams = new PutFileParams();
        putFileParams.setFileId(path);
        PutFileResult putFileResult = client.putFile(putFileParams, file.getInputStream());
        return putFileResult.getAccessUrl();
    }


    /**
     * 检查文件大小
     * 判断文件大小:true:通过；false：不通过
     *
     * @param len  文件长度
     * @param size 限制大小
     * @param unit 限制单位（B,K,M,G）
     * @return boolean
     */
    private static boolean checkFileSize(Long len, int size, String unit) {
        double fileSize = 0;
        if ("B".equals(unit)) {
            fileSize = len;
        } else if ("K".equals(unit)) {
            fileSize = (double) len / 1024;
        } else if ("M".equals(unit)) {
            fileSize = (double) len / 1048576;
        } else if ("G".equals(unit)) {
            fileSize = (double) len / 1073741824;
        }
        return fileSize < size;
    }


}
