package cn.com.duiba.galaxy.console.manager.impl.credits;

import cn.com.duiba.galaxy.adapter.base.adapter.PrizeAdapter;
import cn.com.duiba.galaxy.adapter.base.dto.ProjectXItemDto;
import cn.com.duiba.galaxy.adapter.base.enums.AdapterTypeEnum;
import cn.com.duiba.galaxy.adapter.base.handler.GalaxyAdapterFactory;
import cn.com.duiba.galaxy.adapter.base.params.ItemListParam;
import cn.com.duiba.galaxy.basic.enums.PrizeTypeEnum;
import cn.com.duiba.galaxy.console.enums.ItemTypeEnum;
import cn.com.duiba.galaxy.console.manager.ItemManager;
import cn.com.duiba.galaxy.console.model.param.item.ItemListQueryParam;
import cn.com.duiba.galaxy.console.model.vo.item.ItemVo;
import cn.com.duiba.galaxy.core.annotation.ConditionalOnBizScene;
import cn.com.duiba.galaxy.core.enums.BizSceneEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author zhangdaqing
 * @Date 2022/10/20 16:09
 **/
@Service
@ConditionalOnBizScene(BizSceneEnum.CREDITS_MALL_V1)
public class CreditsItemManagerImpl implements ItemManager {

    @Autowired
    private GalaxyAdapterFactory<PrizeAdapter> galaxyAdapterFactory;

    /**
     * 列表商品
     *
     * @param param 参数
     * @return {@link List}<{@link ItemVo}>
     */
    @Override
    public List<ItemVo> listItem(ItemListQueryParam param) {

        PrizeAdapter adapter = galaxyAdapterFactory.getAdapterByType(AdapterTypeEnum.CREDIT,"PrizeAdapter");
        ItemListParam p=new ItemListParam();
        switch (PrizeTypeEnum.getByCode(param.getItemType())){
            case REAL:p.setType(ItemTypeEnum.OBJECT.getType());
                break;
            case COUPON:p.setType(ItemTypeEnum.COUPONS.getType());
                break;
            case COUPONS_KM:{p.setType(ItemTypeEnum.COUPONS.getType());
            p.setCdkey(1);}
                break;
            case DUIBA_VIRTUAL:p.setType(ItemTypeEnum.DUIBA_VIRTUAL.getType());
                break;
            case VIRTUAL:p.setType(ItemTypeEnum.VIRTUAL.getType());
                break;
            case CREDITS:p.setType(ItemTypeEnum.CREDITS.getType());
                break;
            case ALIPAY:p.setType(ItemTypeEnum.ALIPAY.getType());
                break;
            case PHONE_BILL:p.setType(ItemTypeEnum.PHONE_BILL.getType());
                break;
        }
        p.setItemName(param.getItemName());
        p.setBizId(param.getBizId());
        p.setBizType(param.getBizType());
        p.setPageNo(param.getPageNum());
        p.setPageSize(param.getPageSize());
        p.setItemId(param.getItemId());
        List<ProjectXItemDto> projectXItemDtos = adapter.itemList(p);
        if(CollectionUtils.isEmpty(projectXItemDtos)){
            return new ArrayList<>();
        }

        List<ItemVo> itemVos = projectXItemDtos.stream().map(i->{
            ItemVo vo=new ItemVo();

            vo.setItemIcon(i.getIcon());
            vo.setItemName(i.getItemName());
            vo.setItemId(Objects.nonNull(i.getItemId())?i.getItemId().toString():i.getAppItemId().toString());
            vo.setCostPrice(i.getActualPrice());
            vo.setItemType(Objects.nonNull(i.getItemType())?ItemTypeEnum.getByType(i.getItemType()).getCode():null);
            vo.setItemSubType(i.getSubType());
            vo.setTotalStock(i.getStock());
            if(Objects.nonNull(i.getMultiSku())){
                vo.setSpecificationType(i.getMultiSku()?2:1);
            }
            return vo;

        }).collect(Collectors.toList());
        return itemVos;
    }
}
