package cn.com.duiba.galaxy.console.model.param;

import cn.com.duiba.galaxy.console.model.param.valid.GroupByProjectCreateSource;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;

/**
 * 基础属性json参数
 *
 * @author zhangdaqing
 * @Date 2022/10/15 22:57
 **/
@Getter
@Setter
public class BaseAttributesJsonParam {
    /**
     * 活动名称
     */
    @NotBlank
    private String activityName;
    /**
     * 缩略图(积分商城的活动必填)
     */
    @NotBlank(groups = {GroupByProjectCreateSource.CreditsStore.class})
    private String thumbnail;
    /**
     * banner(积分商城的活动必填)
     */
    @NotBlank(groups = {GroupByProjectCreateSource.CreditsStore.class})
    private String banner;
    /**
     * 活动规则
     */
    @NotBlank
    private String activityRule;
}
