package cn.com.duiba.galaxy.console.model.param;

import cn.com.duiba.galaxy.core.annotation.EnumValue;
import cn.com.duiba.galaxy.core.annotation.ObjectValue;
import cn.com.duiba.galaxy.core.enums.ConfigType;
import com.alibaba.fastjson.JSONObject;

import javax.validation.constraints.NotNull;

/**
 * 检查参数
 *
 * @author zhangdaqing
 * @date 2022/10/12
 */
public class CheckParam {
    /**
     * 校验类型
     * 1, "自定义配置",
     * 2, "奖品配置",
     * 3, "发奖规则配置",
     * 4, "玩法配置",
     * 5, "皮肤配置",
     * 6, "奖项配置",
     * 7, "接口配置",
     * 8, "java代码包配置",
     */
    @NotNull
    @EnumValue(clazz = ConfigType.class)
    private Integer type;
    /**
     * 配置项内容
     */
    @NotNull
    private JSONObject content;
    /**
     * 模式  1原型  2活动
     */
    @NotNull
    @ObjectValue(intValues = {1, 2})
    private int mode;

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public JSONObject getContent() {
        return content;
    }

    public void setContent(JSONObject content) {
        this.content = content;
    }

    public int getMode() {
        return mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }
}
