package cn.com.duiba.galaxy.console.model.param;

import cn.com.duiba.galaxy.basic.enums.ConfigTypeEnum;
import cn.com.duiba.galaxy.console.enums.CustomConfigVariableTypeEnum;
import cn.com.duiba.galaxy.core.annotation.EnumValue;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * 自定义配置json
 *
 * @author zhangdaqing
 * @Date 2022/10/15 17:37
 **/
@NoArgsConstructor
@Getter
@Setter
public class CustomConfigJsonParam {

    /**
     * 配置项名称
     */
    @NotBlank
    private String name;
    /**
     * 配置项变量
     */
    @Pattern(regexp = "[a-zA-Z][a-zA-Z\\d_]*", message = "格式有误")
    private String variable;
    /**
     * 校验
     */
    private String valid;
    /**
     * 类型
     *
     * @see cn.com.duiba.galaxy.console.enums.CustomConfigVariableTypeEnum
     */
    @NotNull
    @EnumValue(clazz = CustomConfigVariableTypeEnum.class)
    private Integer type;
    /**
     * 配置类型(前端配置项，后端配置项，运营配置项)
     *
     * @see ConfigTypeEnum
     */
    @EnumValue(clazz = ConfigTypeEnum.class)
    private Integer configType;
    /**
     * 提示
     */
    @NotBlank
    private String tips;
    /**
     * 值
     */
    private String value;
    /**
     * 描述(type为JSONArray时必填)
     */
    private String desc;

}
