package cn.com.duiba.galaxy.console.model.param;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * Created by hong
 * time 2022/10/29.
 */
@Data
public class OperationalOptionParam {
    private Long id;

    /**
     * 活动id
     */
    private Long projectId;

    /**
     * 出奖规则id
     */
    private String ruleId;

    /**
     * 出奖规则名称
     */
    private String ruleName;

    /**
     * 奖品名
     */
    private String optionName;

    /**
     * 奖项类型：3-采购奖品，1-道具，0-谢谢参与
     */
    private Integer optionType;

    /**
     * 已获得奖项图片
     */
    private String optionImg1;

    /**
     * 未获得奖项图片
     */
    private String optionImg2;

    /**
     * 奖品ID：1-采购奖品ID，2-道具ID
     */
    private Long prizeId;

    /**
     * 中奖概率小数点后2位
     */
    private BigDecimal rate;

    /**
     * 概率类型：1-普通概率；2-替补必中
     */
    private Integer rateType;

    /**
     * 项目配置数据
     */
    private String ext;

    /**
     * 总库存
     */
    private Integer totalStock;

    /**
     * 已使用库存
     */
    private Integer usedStock;

    /**
     * 是否删除，1-已删除，0-未删除
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 用户中奖限制次数
     */
    private Long userLimit;

    /**
     * 用户中奖限制类型(日，周，月，永久)
     */
    private Integer userLimitType;

    /**
     * 发奖限制
     */
    private Long awardLimit;

    /**
     * 发奖限制类型(日，周，月，永久)
     */
    private Integer awardLimitType;

    /**
     * 奖项位置
     */
    private Integer pos;

    /**
     * 是否在首页展示 0 不展示 ， 1展示
     */
    private Integer showIndexType;

    /**
     * 保底次数(针对用户维度，产生多少次抽奖行为才会中奖)
     */
    private Long atleastTimes;

    /**
     * 单次发放个数(仅道具)
     */
    private Long sendCount;

    /**
     * 是否允许多奖项
     */
    private Integer multipleOption;

    /**
     * 是否修改
     */
    private Integer modify;

    /**
     * 商品id
     */
    private String itemId;

    /**
     * 商品类型
     */
    private Integer itemType;

    /**
     * 商品来源
     */
    private Integer bizType;

}
