package cn.com.duiba.galaxy.console.model.param;

import lombok.Getter;
import lombok.Setter;

import javax.validation.Valid;
import java.util.List;

/**
 * 玩法配置JSON
 *
 * @author fangxiaorun
 * @date 2022/10/15
 */
@Getter
@Setter
public class PlayAttributesJsonParam {

    /**
     * java代码
     */
    //@NotBlank(groups = {GroupByResponsibility.Developer.class})
    private String javaCode;
    /**
     * 开发看板
     */
    //@NotBlank(groups = {GroupByResponsibility.Developer.class})
    private String cfUrl;
    /**
     * 皮肤配置
     */
    @Valid
    //@NotEmpty(groups = {GroupByResponsibility.Developer.class})
    private List<SkinJsonParam> skins;


    /**
     * 场景配置项
     */
    @Valid
    private List<SceneJsonParam> scene;
    /**
     * 自定义配置项
     */
    @Valid
    private List<CustomConfigJsonParam> customConfig;
    /**
     * 发奖规则配置
     */
    @Valid
    private List<StrategyJsonParam> rules;
}