package cn.com.duiba.galaxy.console.model.param;

import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * 活动实例扩展表
 *
 * @author zhangdaqing
 * @date 2022/10/13
 */
@Getter
@Setter
public class ProjectExtParam {
    /**
     * 活动实例id
     */
    @NotNull
    private Long projectId;

    /**
     * 开发人员
     */
    @NotBlank
    private String developers;

    /**
     * 运营人员
     */
    @NotBlank
    private String operators;

    /**
     * 测试人员
     */
    @NotBlank
    private String testers;

    /**
     * 大雁关联项目
     */
    @NotBlank
    private DayanProjectParam dayanProject;

    /**
     * 效果标签
     */
    private List<String> effectTags;

    /**
     * 链接投放开始时间
     */
    private Date throwStartTime;

    /**
     * 链接投放结束时间
     */
    private Date throwEndTime;


}
