package cn.com.duiba.galaxy.console.model.param;

import cn.com.duiba.galaxy.console.model.param.valid.GroupByResponsibility;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * 场景
 *
 * @author fangxiaorun
 * @date 2022/10/15
 */
@Getter
@Setter
public class SceneJsonParam {

    /**
     * 奖品场景名称
     */
    @NotBlank
    private String prizeSceneName;
    /**
     * 奖品场景发奖规则id
     */
    @NotEmpty(groups = {GroupByResponsibility.Operator.class})
    @Size(groups = {GroupByResponsibility.Operator.class}, min = 1, max = 3)
    private List<String> prizeSceneRuIds;
    /**
     * 场景id
     */
    @NotBlank
    private String prizeSceneId;
}