package cn.com.duiba.galaxy.console.model.param.item;

import cn.com.duiba.galaxy.adapter.base.enums.ItemBizTypeEnum;
import cn.com.duiba.galaxy.basic.enums.PrizeTypeEnum;
import cn.com.duiba.galaxy.sdk.params.PageParams;
import lombok.Getter;
import lombok.Setter;

/**
 * 商品列表查询参数
 *
 * @author zhangdaqing
 * @Date 2022/10/20 14:56
 **/
@Getter
@Setter
public class ItemListQueryParam extends PageParams {
    /**
     * 商品类型
     * @see PrizeTypeEnum
     */
    private Integer itemType;
    /**
     * 商品名称
     */
    private String itemName;

    /**
     * 业务类型
     * @see ItemBizTypeEnum
     */
    private Integer bizType;

    /**
     * 业务类型对应传入id
     */
    private Long bizId;

    /**
     * 筛选商品id
     */
    private Long itemId;
}
