package cn.com.duiba.galaxy.console.model.param.project;

import cn.com.duiba.galaxy.basic.enums.ProjectCreateSourceEnum;
import cn.com.duiba.galaxy.basic.enums.PrototypeTypeEnum;
import cn.com.duiba.galaxy.console.model.param.valid.GroupByProjectType;
import cn.com.duiba.galaxy.core.annotation.EnumValue;
import cn.com.duiba.galaxy.core.annotation.ObjectValue;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;


/**
 * 项目新建参数
 *
 * @author zhangdaqing
 * @date 2022/10/09
 */
@Getter
@Setter
public class ProjectNewParam {
    /**
     * 大雁项目id
     */
    @NotBlank(groups = GroupByProjectType.Custom.class)
    private String dayanProjectId;

    @NotBlank(groups = GroupByProjectType.Custom.class)
    private String dayanProjectName;
    /**
     * 原型id
     */
    @NotNull
    private Long prototypeId;
    /**
     * 项目名称
     */
    @NotBlank
    private String projectName;
    /**
     * 0 测试项目，1 正式项目
     */
    @NotNull
    @ObjectValue(intValues = {0, 1})
    private Integer prod;

    /**
     * 来源 0活动平台,1积分商城
     */
    @NotNull
    @EnumValue(clazz = ProjectCreateSourceEnum.class)
    private Integer source;


    /**
     * 原型类型  1定制，2模板
     */
    @EnumValue(clazz = PrototypeTypeEnum.class)
    private Integer prototypeType;
}
