package cn.com.duiba.galaxy.console.model.param.project;

import cn.com.duiba.galaxy.console.enums.ProjectUpdateButtonTypeEnum;
import cn.com.duiba.galaxy.console.model.param.BaseAttributesJsonParam;
import cn.com.duiba.galaxy.console.model.param.PlayAttributesJsonParam;
import cn.com.duiba.galaxy.console.model.param.ProjectExtParam;
import cn.com.duiba.galaxy.console.model.param.ViewAttributesJsonParam;
import cn.com.duiba.galaxy.console.model.param.valid.GroupByProjectType;
import cn.com.duiba.galaxy.core.annotation.EnumValue;
import cn.com.duiba.galaxy.core.annotation.ObjectValue;
import lombok.Getter;
import lombok.Setter;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 项目更新参数
 *
 * @author zhangdaqing
 * @Date 2022/10/8 16:25
 **/
@Getter
@Setter
public class ProjectUpdateParam {


    /**
     * 项目id
     */
    @NotNull
    private Long id;

    /**
     * 开始时间
     */
    private Date startTime;
    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 项目名称
     */
    @NotBlank
    private String projectName;

    /**
     * 是否是正式项目 0非正式,1正式
     */
    @ObjectValue(intValues = {0, 1})
    private Integer prod;

    /**
     * 扩展属性
     */
    @NotNull(groups = {GroupByProjectType.Custom.class})
    private ProjectExtParam projectExtra;

    /**
     * 玩法属性
     */
    @Valid
    private PlayAttributesJsonParam playAttributes;


    /**
     * 基础属性
     */
    @NotNull
    @Valid
    private BaseAttributesJsonParam baseAttributes;


    /**
     * 视觉属性
     */
    @Valid
    private ViewAttributesJsonParam viewAttributes;

    /**
     * 按钮类型 1保存(仅针对活动未上线时)，2保存并发布
     */
    @NotNull
    @EnumValue(clazz = ProjectUpdateButtonTypeEnum.class)
    private Integer buttonType;

    /**
     * 修改时间
     */
    private Date gmtModified;

}
