package cn.com.duiba.galaxy.console.model.param.project;

import cn.com.duiba.galaxy.basic.enums.ProjectStateEnum;
import cn.com.duiba.galaxy.core.annotation.ObjectValue;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;

/**
 * 更新项目状态参数
 *
 * @author zhangdaqing
 * @Date 2022/10/19 17:28
 **/
@Getter
@Setter
public class UpdateProjectStateParam {
    /**
     * projectId
     */
    @NotNull
    private Long projectId;

    /**
     * 状态
     * @see ProjectStateEnum
     */
    @NotNull
    @ObjectValue(intValues = {3, 4})
    private Integer state;
}
