package cn.com.duiba.galaxy.console.model.param.prototype;

import cn.com.duiba.galaxy.basic.enums.PrototypeTypeEnum;
import cn.com.duiba.galaxy.core.annotation.EnumValue;
import cn.com.duiba.galaxy.core.enums.PlaywayTypeEnum;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;


/**
 * 原型保存参数
 *
 * @author zhangdaqing
 * @date 2022/10/09
 */
@Getter
@Setter
public class PrototypeSaveParam {
    /**
     * 原型名称
     */
    @NotBlank
    @Length(max = 30, message = "原型名称长度超出限制")
    private String prototypeName;

    /**
     * 原型类型
     */
    @NotNull(message = "原型类型不能为空")
    @EnumValue(clazz = PrototypeTypeEnum.class)
    private Integer prototypeType;

    /**
     * 玩法选型
     */
    @NotNull(message = "玩法类型不能为空")
    @EnumValue(clazz = PlaywayTypeEnum.class)
    private Integer playwayType;
}
