package cn.com.duiba.galaxy.console.model.param.prototype;

import cn.com.duiba.galaxy.console.model.param.PlayAttributesJsonParam;
import cn.com.duiba.galaxy.console.model.param.SpParam;
import cn.com.duiba.galaxy.console.model.param.ViewAttributesJsonParam;
import cn.com.duiba.galaxy.core.annotation.EnumValue;
import cn.com.duiba.galaxy.core.enums.PlaywayTypeEnum;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.validator.constraints.Length;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 原型更新入参
 *
 * @author zhangdaqing
 * @Date 2022/10/9 17:02
 **/
@Getter
@Setter
public class PrototypeUpdateParam {

    /**
     * id
     */
    @NotNull
    private Long id;
    /**
     * 原型名称
     */
    @NotBlank
    @Length(max = 30, message = "原型名称长度超出限制")
    private String prototypeName;

    /**
     * 玩法选型
     */
    @NotNull(message = "玩法类型不能为空")
    @EnumValue(clazz = PlaywayTypeEnum.class)
    private Integer playwayType;

    /**
     * 视觉属性
     */
    @Valid
    private ViewAttributesJsonParam viewAttributes;

    /**
     * 玩法属性
     */
    @Valid
    private PlayAttributesJsonParam playAttributes;

    @Valid
    private List<SpParam> sps;

    /**
     * 原型代码唯一值
     */
    private String commitId;


}
