package cn.com.duiba.galaxy.console.model.param.prototype;

import cn.com.duiba.galaxy.basic.enums.ProjectStateEnum;
import cn.com.duiba.galaxy.console.enums.PrototypeStateEnum;
import cn.com.duiba.galaxy.core.annotation.EnumValue;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;

/**
 * 更新项目状态参数
 *
 * @author zhangdaqing
 * @Date 2022/10/19 17:28
 **/
@Getter
@Setter
public class UpdatePrototypeStateParam {
    /**
     * 原型id
     */
    @NotNull
    private Long prototypeId;

    /**
     * 状态
     * @see ProjectStateEnum
     */
    @NotNull
    @EnumValue(clazz = PrototypeStateEnum.class)
    private Integer state;
}
