package cn.com.duiba.galaxy.console.model.param.template;

import cn.com.duiba.galaxy.console.enums.TemplateSyncStateEnum;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 新建模版入参
 *
 * @author fangxiaorun
 * @date 2022/09/29
 */
@Getter
@Setter
public class TemplateSyncParam {

    /**
     * 模版ID
     */
    @NotNull
    private Long templateId;

    /**
     * 同步类型
     *
     * @see TemplateSyncStateEnum#getCode()
     */
    @Range(min = 0, max = 2)
    private Integer syncType;

    /**
     * 定向app集合
     */
    private List<Integer> syncApp;
}




