package cn.com.duiba.galaxy.console.model.vo;

import cn.com.duiba.galaxy.basic.enums.ConfigTypeEnum;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * 自定义配置json
 *
 * @author zhangdaqing
 * @Date 2022/10/15 17:37
 **/
@NoArgsConstructor
@Getter
@Setter
public class CustomConfigJsonVo {

    /**
     * 配置项名称
     */
    private String name;
    /**
     * 配置项变量
     */
    private String variable;
    /**
     * 校验
     */
    private String valid;
    /**
     * 类型
     *
     * @see cn.com.duiba.galaxy.console.enums.CustomConfigVariableTypeEnum
     */
    private Integer type;
    /**
     * 配置类型(前端配置项，后端配置项，运营配置项)
     *
     * @see ConfigTypeEnum
     */
    private Integer configType;
    /**
     * 提示
     */
    private String tips;
    /**
     * 值
     */
    private String value;
    /**
     * 描述(type为JSONArray时必填)
     */
    private String desc;

}
