package cn.com.duiba.galaxy.console.model.vo;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 项目扩展基础VO
 * 活动实例扩展表
 *
 * @author zhangdaqing
 * @date 2022/10/13
 */
@Getter
@Setter
public class ProjectExtraBaseVo implements Serializable {

    /**
     * 主键id
     */
    private Long id;

    /**
     * 活动实例id
     */
    private Long projectId;

    /**
     * 开发人员
     */
    private String developers;

    /**
     * 运营人员
     */
    private String operators;

    /**
     * 测试人员
     */
    private String testers;

    /**
     * 大雁关联项目
     */
    private DayanProjectVo dayanProject;

    /**
     * 效果标签
     */
    private List<String> effectTags;

    /**
     * 链接投放开始时间
     */
    private Date throwStartTime;

    /**
     * 链接投放结束时间
     */
    private Date throwEndTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;


}
