package cn.com.duiba.galaxy.console.model.vo;

import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 出奖策略json
 *
 * @author zhangdaqing
 * @Date 2022/10/16 22:53
 **/
@Getter
@Setter
public class StrategyJsonVo {
    /**
     * 发奖规则id
     */
    private String id;
    /**
     * 发奖规则类型（1概率出奖，2百分百中奖）
     */
    private Integer type;
    /**
     * 规则是否启用 true 启用
     */
    private Boolean strategyEnable;
    /**
     * 发奖规则名称
     */
    private String name;
    /**
     * 分层是否启用 true 启用
     */
    private boolean layeredEnable;
    /**
     * 分层类型 1区分奖池，2区分概率
     */
    private Integer layeredType;

    /**
     * 奖项列表
     */
    private List<OptionJsonVo> options;

    /**
     * 多个奖项限制
     */
    private MultipleOptionLimitJsonVo multipleOptionLimit;

    /**
     * 分层规则
     */
    private List<LayeredRuleJsonVo> layeredRules;

    /**
     * 身份
     */
    private String layeredIdentity;


}
