package cn.com.duiba.galaxy.console.model.vo;

import cn.com.duiba.galaxy.console.model.vo.prototype.PrototypeListVo;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 页面原型签证官
 *
 * @author zhangdaqing
 * @Date 2022/9/30 16:06
 * @desc
 **/
@Getter
@Setter
public class PagePrototypeVo {
    /**
     * 列表
     */
    private List<PrototypeListVo> list;
    /**
     * 总条数
     */
    private long totalCount;

    private PagePrototypeVo(Builder builder) {
        setList(builder.list);
        setTotalCount(builder.totalCount);
    }

    public static Builder newBuilder() {
        return new Builder();
    }


    /**
     * {@code PagePrototypeVo} builder static inner class.
     */
    public static final class Builder {
        private List<PrototypeListVo> list;
        private long totalCount;

        private Builder() {
        }

        /**
         * Sets the {@code list} and returns a reference to this Builder enabling method chaining.
         *
         * @param val the {@code list} to set
         * @return a reference to this Builder
         */
        public Builder list(List<PrototypeListVo> val) {
            list = val;
            return this;
        }

        /**
         * Sets the {@code totalCount} and returns a reference to this Builder enabling method chaining.
         *
         * @param val the {@code totalCount} to set
         * @return a reference to this Builder
         */
        public Builder totalCount(long val) {
            totalCount = val;
            return this;
        }

        /**
         * Returns a {@code PagePrototypeVo} built from the parameters previously set.
         *
         * @return a {@code PagePrototypeVo} built with parameters of this {@code PagePrototypeVo.Builder}
         */
        public PagePrototypeVo build() {
            return new PagePrototypeVo(this);
        }
    }
}

