package cn.com.duiba.galaxy.console.model.vo.template;

import cn.com.duiba.galaxy.console.enums.PrototypeStateEnum;
import cn.com.duiba.galaxy.console.enums.TemplateSyncStateEnum;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;
import java.util.List;

/**
 * 模板表VO
 *
 * @author fangxiaorun
 * @date 2022/09/30
 */
@Getter
@Setter
public class TemplateVo {

    /**
     * 模板id
     */
    private Long id;

    /**
     * 模版名称
     */
    private String templateName;

    /**
     * 模版海报
     */
    private String templatePoster;

    /**
     * 模版类型
     */
    private Integer templateType;

    /**
     * 关联原型ID
     */
    private Long prototypeId;

    /**
     * 模板同步状态
     *
     * @see TemplateSyncStateEnum#getCode()
     */
    private Integer syncType;

    /**
     * 原型状态
     *
     * @see PrototypeStateEnum#getCode()
     */
    private Integer prototypeState;

    /**
     * 同步的目标APP集合
     */
    private List<Integer> syncApp;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}




