package cn.com.duiba.galaxy.console.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.galaxy.api.model.dto.EnumDto;
import cn.com.duiba.galaxy.api.remote.RemoteCommonBackendService;
import cn.com.duiba.galaxy.console.enums.PlatformConsoleErrorEnum;
import cn.com.duiba.galaxy.console.manager.CommonBackendManager;
import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;
import cn.hutool.core.bean.BeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 管理后台通用服务
 * 注：仅供积分商城调用
 *
 * @author fangxiaorun
 * @date 2022/11/7
 */
@Slf4j
@RestController
public class RemoteCommonBackendServiceImpl implements RemoteCommonBackendService {

    @Autowired
    private CommonBackendManager commonBackendManager;

    @Override
    public List<EnumDto> getEnumByName(String name) throws BizException {
        try {
            return BeanUtil.copyToList(commonBackendManager.getEnumByName(name), EnumDto.class);
        } catch (BizRuntimeException e) {
            throw new BizException(e.getMessage()).withCode(e.getCode());
        } catch (Exception e) {
            log.error("Exception [{}]\nname={}:", e.getMessage(), name, e);
            PlatformConsoleErrorEnum consoleEx = PlatformConsoleErrorEnum.SYSTEM_ERROR;
            throw new BizException(consoleEx.getDesc()).withCode(consoleEx.getCode());
        }
    }
}