package cn.com.duiba.galaxy.console.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.galaxy.api.model.dto.CreditsResponse;
import cn.com.duiba.galaxy.api.remote.RemoteGalaxyNotifyCreditsService;
import cn.com.duiba.galaxy.basic.model.entity.migration.CreditsRecordEntity;
import cn.com.duiba.galaxy.console.enums.TicketRecordExtraType;
import cn.com.duiba.galaxy.core.service.credits.CreditsService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 扣积分通知回调服务
 *
 * @author zhengjianhao
 * @date 2022/10/28
 */
@RestController
@Slf4j
public class RemoteGalaxyNotifyCreditsServiceImpl implements RemoteGalaxyNotifyCreditsService {

    private static final String OK = "ok";
    private static final String FAIL = "fail";

    @Resource
    private CreditsService creditsService;

    @Override
    public void creditsCallback(CreditsResponse resp) throws BizException {
        if (resp == null) {
            throw new BizException("params is null");
        }
        if (StringUtils.isEmpty(resp.getOrderNum())) {
            throw new BizException("orderNum is null");
        }
        if (StringUtils.isEmpty(resp.getStatus())) {
            throw new BizException("status is null");
        }

        try {
            Integer status = null;
            CreditsRecordEntity creditsRecordEntity = creditsService.find(resp.getOrderNum());
            String extra = creditsRecordEntity.getExtra();
            if (OK.equalsIgnoreCase(resp.getStatus())) {
                status = CreditsRecordEntity.SUCCESS;
            } else if (FAIL.equalsIgnoreCase(resp.getStatus())) {
                status = CreditsRecordEntity.FAIL;
                JSONObject extraJsonObject;
                if (StringUtils.isNotBlank(extra)) {
                    extraJsonObject = JSON.parseObject(extra);
                } else {
                    extraJsonObject = new JSONObject();
                }
                extraJsonObject.put(TicketRecordExtraType.THIRDPARTY_CREDIT_FAIL_RESP.getKey(), resp.getResponseBody());
                extra = extraJsonObject.toJSONString();
            }
            creditsService.updateStatus(resp.getOrderNum(), status, resp.getBizId(), extra);
        } catch (Exception e) {
            log.error("creditsCallback", e);
            throw new BizException("扣积分回调异常" + e.getMessage());
        }
    }

}
