package cn.com.duiba.galaxy.console.remote;

import cn.com.duiba.galaxy.adapter.base.adapter.PrizeAdapter;
import cn.com.duiba.galaxy.adapter.base.enums.AdapterTypeEnum;
import cn.com.duiba.galaxy.adapter.base.handler.GalaxyAdapter;
import cn.com.duiba.galaxy.adapter.base.handler.GalaxyAdapterFactory;
import cn.com.duiba.galaxy.adapter.base.params.ItemListParam;
import cn.com.duiba.galaxy.api.model.dto.RemoteProjectXItemDto;
import cn.com.duiba.galaxy.api.model.param.RemoteItemListParam;
import cn.com.duiba.galaxy.api.remote.RemotePrizeService;
import cn.com.duiba.galaxy.basic.model.entity.migration.UserPrizeRecordEntity;
import cn.com.duiba.galaxy.basic.service.migration.BaseRepository;
import cn.com.duiba.galaxy.basic.service.migration.UserPrizeRepository;
import cn.com.duiba.galaxy.core.service.base.UserPrizeRecordService;
import cn.com.duiba.galaxy.sdk.SendPrizeContext;
import cn.com.duiba.galaxy.sdk.logger.BuriedPointInfoEnum;
import cn.com.duiba.galaxy.sdk.logger.BuriedPointService;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 奖品服务
 */
@RestController
@Slf4j
public class RemotePrizeServiceImpl implements RemotePrizeService {


    @Resource
    private UserPrizeRecordService userPrizeRecordService;

    @Resource
    private UserPrizeRepository userPrizeRepository;

    @Resource
    private BuriedPointService buriedPointService;

    @Resource
    private GalaxyAdapterFactory<GalaxyAdapter> galaxyAdapterFactory;


    /**
     * @param extra
     * @param orderNo
     * @param status  0初始化，1发奖中/扣库存中，2待领取，3领取中，4已领取，5领奖失败
     */
    @Override
    public void updatePrizeStatus(String extra, Long orderNo, Integer status) {

        log.info("发奖状态回调 {} {} {}", extra, orderNo, status);
        if (StringUtils.isBlank(extra) && !JSONValidator.from(extra).validate()) {
            log.warn("发奖状态回调处理失败");
            return;
        }
        JSONObject extraJson = JSON.parseObject(extra);
        UserPrizeRecordEntity entity = userPrizeRepository.find(extraJson.getLong(SendPrizeContext.PROJECT_ID), orderNo);
        if (entity == null) {
            log.warn("发奖状态回调处理失败，没有对应奖品记录");
            return;
        }
        entity.setDrawStatus(status);
        userPrizeRecordService.update(entity);

        String tableSuffix = BaseRepository.getTableSuffix(entity.getProjectId());
        buriedPointService.put(BuriedPointInfoEnum.EventType.ACTIVITY_AWARD_RECEIVE.builder(tableSuffix + "_" + entity.getId(), entity.getOptionId()));
    }

    @Override
    public List<RemoteProjectXItemDto> itemList(RemoteItemListParam itemListParam) {
        PrizeAdapter prizeAdapter = galaxyAdapterFactory.getAdapterByType(AdapterTypeEnum.CREDIT, "PrizeAdapter");
        return BeanUtils.copyList(prizeAdapter.itemList(BeanUtils.copy(itemListParam, ItemListParam.class)),RemoteProjectXItemDto.class);
    }
}
