package cn.com.duiba.galaxy.console.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.galaxy.api.model.dto.ProjectDto;
import cn.com.duiba.galaxy.api.model.param.ProjectNewOrUpdateParam;
import cn.com.duiba.galaxy.api.remote.RemoteProjectBackendService;
import cn.com.duiba.galaxy.console.enums.PlatformConsoleErrorEnum;
import cn.com.duiba.galaxy.console.manager.ProjectManager;
import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;
import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * "项目"远程服务实现
 *
 * @author fangxiaorun
 * @date 2022/10/17
 */
@RestController
@Slf4j
public class RemoteProjectBackendServiceImpl implements RemoteProjectBackendService {

    @Resource
    private ProjectManager projectManager;

    @Override
    public Long createForMall(ProjectNewOrUpdateParam param) throws BizException {
        try {
            return projectManager.createForMall(param);
        } catch (BizRuntimeException e) {
            throw new BizException(e.getMessage()).withCode(e.getCode());
        } catch (Exception e) {
            log.error("Exception [{}]\nparam={}:", e.getMessage(), JSON.toJSONString(param), e);
            PlatformConsoleErrorEnum consoleEx = PlatformConsoleErrorEnum.SYSTEM_ERROR;
            throw new BizException(consoleEx.getDesc()).withCode(consoleEx.getCode());
        }
    }

    @Override
    public Boolean updateForMall(ProjectNewOrUpdateParam param) throws BizException {
        try {
            return projectManager.updateForMall(param);
        } catch (BizRuntimeException e) {
            throw new BizException(e.getMessage()).withCode(e.getCode());
        } catch (Exception e) {
            log.error("Exception [{}]\nparam={}:", e.getMessage(), JSON.toJSONString(param), e);
            PlatformConsoleErrorEnum consoleEx = PlatformConsoleErrorEnum.SYSTEM_ERROR;
            throw new BizException(consoleEx.getDesc()).withCode(consoleEx.getCode());
        }
    }

    @Override
    public ProjectDto getById(Long id) throws BizException {
        try {
            return BeanUtil.copyProperties(projectManager.getProjectByProjectId(id), ProjectDto.class);
        } catch (BizRuntimeException e) {
            throw new BizException(e.getMessage()).withCode(e.getCode());
        } catch (Exception e) {
            log.error("Exception [{}]\nid={}:", e.getMessage(), id, e);
            PlatformConsoleErrorEnum consoleEx = PlatformConsoleErrorEnum.SYSTEM_ERROR;
            throw new BizException(consoleEx.getDesc()).withCode(consoleEx.getCode());
        }
    }

    @Override
    public Boolean updateState(Long projectId, Integer state) throws BizException {
        try {
            return projectManager.updateState(projectId, state);
        } catch (BizRuntimeException e) {
            throw new BizException(e.getMessage()).withCode(e.getCode());
        } catch (Exception e) {
            log.error("Exception [{}]\nprojectId={},state={}:", e.getMessage(), projectId, state, e);
            PlatformConsoleErrorEnum consoleEx = PlatformConsoleErrorEnum.SYSTEM_ERROR;
            throw new BizException(consoleEx.getDesc()).withCode(consoleEx.getCode());
        }
    }

    @Override
    public ProjectDto getReadyCopyProject(Long projectId) {
        return BeanUtil.copyProperties(projectManager.getReadyCopyProject(projectId), ProjectDto.class);
    }
}