package cn.com.duiba.galaxy.console.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.galaxy.api.model.dto.PrototypeDto;
import cn.com.duiba.galaxy.api.remote.RemotePrototypeBackendService;
import cn.com.duiba.galaxy.basic.service.PrototypeService;
import cn.com.duiba.galaxy.console.enums.PlatformConsoleErrorEnum;
import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;
import cn.hutool.core.bean.BeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

/**
 * "原型"远程服务实现
 *
 * @author fangxiaorun
 * @date 2022/10/14
 */
@RestController
@Slf4j
public class RemotePrototypeBackendServiceImpl implements RemotePrototypeBackendService {

    @Autowired
    private PrototypeService prototypeService;

    @Override
    public PrototypeDto getById(Long id) throws BizException {
        try {
            return BeanUtil.copyProperties(prototypeService.getById(id), PrototypeDto.class);
        } catch (BizRuntimeException e) {
            throw new BizException(e.getMessage()).withCode(e.getCode());
        } catch (Exception e) {
            log.error("Exception [{}]\nid={}:", e.getMessage(), id, e);
            PlatformConsoleErrorEnum consoleEx = PlatformConsoleErrorEnum.SYSTEM_ERROR;
            throw new BizException(consoleEx.getDesc()).withCode(consoleEx.getCode());
        }
    }
}