package cn.com.duiba.galaxy.console.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.galaxy.api.model.dto.SpDto;
import cn.com.duiba.galaxy.api.remote.RemoteSpBackendService;
import cn.com.duiba.galaxy.console.enums.PlatformConsoleErrorEnum;
import cn.com.duiba.galaxy.console.manager.SpManager;
import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;
import cn.hutool.core.bean.BeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * "道具"远程服务实现
 *
 * @author fangxiaorun
 * @date 2022/10/11
 */
@RestController
@Slf4j
public class RemoteSpBackendServiceImpl implements RemoteSpBackendService {

    @Autowired
    private SpManager spManager;

    public List<SpDto> listByPrototypeId(Long prototypeId) throws BizException {
        try {
            return BeanUtil.copyToList(spManager.listAllSps(prototypeId), SpDto.class);
        } catch (BizRuntimeException e) {
            throw new BizException(e.getMessage()).withCode(e.getCode());
        } catch (Exception e) {
            log.error("Exception [{}]\nprototypeId={}:", e.getMessage(), prototypeId, e);
            PlatformConsoleErrorEnum consoleEx = PlatformConsoleErrorEnum.SYSTEM_ERROR;
            throw new BizException(consoleEx.getDesc()).withCode(consoleEx.getCode());
        }
    }
}