package cn.com.duiba.galaxy.console.util;

import org.springframework.web.multipart.MultipartFile;

import java.util.Base64;
import java.util.stream.IntStream;


/**
 * 用于将Base64转换成MultipartFile类型
 *
 * @author zhangdaqing
 * @date 2022/10/11
 */
public class Base64Util {

    private Base64Util() {
    }


    /**
     * 用于将Base64转换成MultipartFile类型
     *
     * @param img64Str base64字符串
     * @return {@link MultipartFile}
     */
    public static MultipartFile base64ToMultipart(String img64Str) {
        try {
            String[] baseStr = img64Str.split(",");
            Base64.Decoder decoder = Base64.getDecoder();
            byte[] b = decoder.decode(baseStr[1]);
            IntStream.range(0, b.length).filter(i -> b[i] < 0).forEach(i -> b[i] += 256);
            return new Base64ToMultipartFileUtil(b, baseStr[0]);
        } catch (Exception e) {
            //log.error("execute Base64Util.base64ToMultipart() failure!\nbase64={}", base64, e);
            return null;
        }
    }
}
