package cn.com.duiba.galaxy.console.util;

import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;


/**
 * 文件idgenerator
 *
 * @author zhangdaqing
 * @date 2022/10/11
 */
public class FileIDGeneratorUtils {

    private static final String CHARACTER = "abcdefghijklmnopqrstuvwxyz0123456789";

    private FileIDGeneratorUtils() {
    }


    /**
     * 得到随机字符串
     *
     * @param length 表示生成字符串的长度
     * @return {@link String}
     */
    public static String getRandomString(int length) {
        return IntStream.range(0, length).map(i -> new Random().nextInt(CHARACTER.length())).mapToObj(number -> String.valueOf(CHARACTER.charAt(number))).collect(Collectors.joining());
    }

}
