package cn.com.duiba.galaxy.console.util;

import cn.com.duiba.galaxy.console.enums.PlatformConsoleErrorEnum;
import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;
import org.apache.commons.lang3.StringUtils;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.UUID;

/**
 * id制造商
 *
 * @author zhangdaqing
 * @date 2022/10/08
 */
public class IdMaker {

    /**
     * ID类型
     */
    public enum IdType {
        p, //项目
        w, //玩法
        a, //接口
        r, //规则
        o, //奖项
        g, //奖品
        f; //皮肤
    }

    /**
     * 生成 32bit ID
     *
     * @return
     */
    private static synchronized String generate4byteId() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[4];
        random.nextBytes(bytes);
        BigInteger bigint = new BigInteger(1, bytes);
        return String.format("%0" + (bytes.length << 1) + "X", bigint).toLowerCase();
    }

    /**
     * 获取项目ID
     *
     * @return
     */
    public static String takeProjectId() {
        return IdType.p + generate4byteId();
    }

    /**
     * 获取玩法ID
     *
     * @return
     */
    public static String takePlaywayId() {
        return IdType.w + generate4byteId();
    }

    /**
     * 获取接口ID
     *
     * @return
     */
    public static String takeActionId() {
        return IdType.a + generate4byteId();
    }

    /**
     * 获取规则ID
     *
     * @return
     */
    public static String takeRuleId() {
        return IdType.r + generate4byteId();
    }

    /**
     * 获取奖品ID
     *
     * @return
     */
    public static String takePrizeId() {
        return IdType.g + generate4byteId();
    }

    /**
     * 获取奖项ID
     *
     * @return
     */
    public static String takeOptionId() {
        return IdType.o + generate4byteId();
    }

    /**
     * 获取皮肤ID
     *
     * @return
     */
    public static String takeSkinId() {
        return IdType.f + generate4byteId();
    }

    /**
     * 获取票据编号
     *
     * @return
     */
    public static String takeTicketNum(String projectId) {
        if (StringUtils.isEmpty(projectId)) {
            throw new BizRuntimeException(PlatformConsoleErrorEnum.NULL_PROJECT);
        }
        String uid = UUID.randomUUID().toString().replaceAll("-", "").substring(9);
        return projectId + uid;
    }


}
