package cn.com.duiba.galaxy.console.util; /**
 * Created by TongGuoBo on 2019/6/19.
 */

import lombok.extern.slf4j.Slf4j;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

/**
 * 文件转换
 *
 * @author zhangdaqing
 * @date 2022/10/11
 */
@Slf4j
public class MultipartFileToFileUtils {

    private MultipartFileToFileUtils() {
    }

    /**
     * MultipartFile 转 File
     *
     * @param file 文件
     * @return {@link File}
     * @throws Exception 异常
     */
    public static File multipartFileToFile(MultipartFile file) throws Exception {

        File toFile = null;
        if (file != null && file.getSize() > 0) {
            InputStream ins;
            ins = file.getInputStream();
            toFile = new File(Objects.requireNonNull(file.getOriginalFilename()));
            inputStreamToFile(ins, toFile);
            ins.close();
        }
        return toFile;
    }

    /**
     * 获取流文件
     *
     * @param ins  ins
     * @param file 文件
     */
    private static void inputStreamToFile(InputStream ins, File file) {

        try {
            try (OutputStream os = new FileOutputStream(file)) {
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = ins.read(buffer, 0, 8192)) != -1) {
                    os.write(buffer, 0, bytesRead);
                }
            }
            ins.close();
        } catch (Exception e) {
            log.error("execute MultipartFileToFile.inputStreamToFile() failure!", e);
        }
    }

}