/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.sdk.api.pay.enums;

import java.util.HashMap;
import java.util.Map;

public enum BankTypeEnum {
    JIEJI_CARD(1, "_DEBIT", "\u501f\u8bb0\u5361"),
    CREDITS_CARD(2, "_CREDIT", "\u4fe1\u7528\u5361");

    private static final Map<Integer, BankTypeEnum> ALL_ENUM_MAP;
    private int bankType;
    private String suffix;
    private String desc;

    private BankTypeEnum(int bankType, String suffix, String desc) {
        this.bankType = bankType;
        this.suffix = suffix;
        this.desc = desc;
    }

    public static BankTypeEnum getBankType(int type) {
        return ALL_ENUM_MAP.get(type);
    }

    public int getBankType() {
        return this.bankType;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        ALL_ENUM_MAP = new HashMap<Integer, BankTypeEnum>();
        for (BankTypeEnum bankType : BankTypeEnum.values()) {
            ALL_ENUM_MAP.put(bankType.getBankType(), bankType);
        }
    }
}

