/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.sdk.base;

import cn.com.duiba.galaxy.sdk.message.BizError;
import javax.validation.constraints.NotNull;

public class JsonResult<T> {
    private static final String SUCCESS_CODE = "000000";
    private static final String SUCCESS_DESC = "OK";
    @NotNull
    private Boolean success;
    @NotNull
    private String code;
    @NotNull
    private String desc;
    @NotNull
    private Long timestamp;
    private T data;

    private JsonResult() {
    }

    private JsonResult(Boolean success, String code, String desc, T data) {
        this.success = success;
        this.desc = desc;
        this.data = data;
        this.code = code;
        this.timestamp = System.currentTimeMillis();
    }

    public static <T> JsonResult<T> success() {
        return JsonResult.success(null);
    }

    public static <T> JsonResult<T> success(T data) {
        return new JsonResult<T>(true, SUCCESS_CODE, SUCCESS_DESC, data);
    }

    public static <T> JsonResult<T> fail(String code, String desc) {
        return new JsonResult<Object>(false, code, desc, null);
    }

    public static <T> JsonResult<T> fail(BizError bizError) {
        return new JsonResult<Object>(false, bizError.getCode(), bizError.getDesc(), null);
    }

    public static <T> JsonResult<T> fail(String message) {
        return new JsonResult<Object>(false, "-1", message, null);
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public T getData() {
        return this.data;
    }
}

