/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.sdk.playway.join;

import cn.com.duiba.galaxy.sdk.UserRequestContext;
import cn.com.duiba.galaxy.sdk.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.sdk.api.tools.inner.lock.DistributedLock;
import cn.com.duiba.galaxy.sdk.message.UnclassifiedStatusEnum;
import cn.com.duiba.galaxy.sdk.playway.join.inner.JoinPlayway;
import cn.com.duiba.galaxy.sdk.playway.join.inner.JoinRecord;
import cn.com.duiba.galaxy.sdk.playway.join.inner.JoinUserRequestApi;
import cn.com.duiba.galaxy.sdk.utils.Conditions;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJoinPlaywayImpl
implements JoinPlayway {
    private static final Logger log = LoggerFactory.getLogger(AbstractJoinPlaywayImpl.class);

    @Override
    @CustomRequestAction(id="queryMyJoinCount", desc="\u67e5\u8be2\u6211\u7684\u53c2\u4e0e\u4fe1\u606f")
    public Map<String, Long> queryMyJoinCount(UserRequestContext context, JoinUserRequestApi joinUserRequestApi) {
        Long total = joinUserRequestApi.queryMyAllCount();
        Long today = joinUserRequestApi.queryMyTodayCount();
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("total", total);
        map.put("today", today);
        return map;
    }

    @Override
    @CustomRequestAction(id="queryMyJoinRecord", desc="\u67e5\u8be2\u6211\u7684\u53c2\u4e0e\u8bb0\u5f55")
    public List<JoinRecord> queryMyJoinRecord(UserRequestContext context, JoinUserRequestApi joinUserRequestApi) {
        List<JoinRecord> records;
        String start = context.getHttpRequest().getParameter("start");
        String end = context.getHttpRequest().getParameter("end");
        if (StringUtils.isNotEmpty((CharSequence)start) && StringUtils.isNotEmpty((CharSequence)end)) {
            Date startDate = DateUtils.getDayDate((String)start);
            Date endDate = DateUtils.getDayDate((String)end);
            records = joinUserRequestApi.queryMyRecords(startDate, endDate);
        } else {
            records = joinUserRequestApi.queryMyRecentRecord(200);
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CustomRequestAction(id="join", desc="\u53c2\u4e0e")
    public Boolean join(UserRequestContext context, JoinUserRequestApi joinUserRequestApi) {
        DistributedLock lock = joinUserRequestApi.getMyUserContext().getMyLock();
        boolean get = lock.tryLock(1, 50L);
        Conditions.expectTrue(get, UnclassifiedStatusEnum.LOCK_FAILD);
        try {
            log.info("\u52a0\u9501\u6210\u529f");
            Boolean bl = this.doJoin(context, joinUserRequestApi);
            return bl;
        }
        finally {
            lock.unlock();
            log.info("\u89e3\u9501\u6210\u529f");
        }
    }

    public abstract Boolean doJoin(UserRequestContext var1, JoinUserRequestApi var2);
}

