/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.common.component.checkin;

import cn.com.duiba.galaxy.common.UserRequestApi;
import cn.com.duiba.galaxy.common.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.common.annotation.Token;
import cn.com.duiba.galaxy.common.annotation.UserConcurrentLock;
import cn.com.duiba.galaxy.common.component.checkin.CheckinApi;
import cn.com.duiba.galaxy.common.component.checkin.CheckinComponentAction;
import cn.com.duiba.galaxy.common.component.checkin.dto.CheckinOptionResult;
import cn.com.duiba.galaxy.common.component.checkin.dto.CheckinQueryResult;
import cn.com.duiba.galaxy.common.component.checkin.dto.CheckinResult;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CheckinComponentActionDefault
extends CheckinComponentAction {
    private final String componentId;

    public CheckinComponentActionDefault(String componentId) {
        this.componentId = componentId;
    }

    @Override
    @Token
    @UserConcurrentLock
    @CustomRequestAction(id="doSign", desc="\u7b7e\u5230")
    public CheckinResult doSign(UserRequestApi api) {
        CheckinApi checkinApi = api.getComponentApi().getCheckinApi();
        return checkinApi.doSignAndSendPrize(this.componentId, api.getUserId(), new Date());
    }

    @Override
    @CustomRequestAction(id="query", desc="\u67e5\u8be2\u7b7e\u5230\u8bb0\u5f55-\u7528\u6237\u7ef4\u5ea6\uff0c\u975e\u7b7e\u5230\u7ef4\u5ea6")
    public CheckinQueryResult query(UserRequestApi api) {
        CheckinApi checkinApi = api.getComponentApi().getCheckinApi();
        Integer intervalType = api.getIntegerParameter("intervalType", 0);
        String startDateStr = api.getStringParameter("startDate");
        Date startDate = StringUtils.isNotBlank((CharSequence)startDateStr) ? DateUtils.getDayStartTime((String)startDateStr) : null;
        String endDateStr = api.getStringParameter("endDate");
        Date endDate = StringUtils.isNotBlank((CharSequence)endDateStr) ? DateUtils.getDayStartTime((String)endDateStr) : null;
        return checkinApi.query(this.componentId, api.getUserId(), intervalType, startDate, endDate);
    }

    @Override
    @CustomRequestAction(id="queryOptions", desc="\u67e5\u8be2\u7b7e\u5230\u5956\u54c1\u914d\u7f6e")
    public List<CheckinOptionResult> queryOptions(UserRequestApi api) {
        CheckinApi checkinApi = api.getComponentApi().getCheckinApi();
        return checkinApi.queryOptions(this.componentId);
    }
}

