package cn.com.duiba.galaxy.sdk.api.base;

/**
 * 主要用于通用的action级别的上下文，如每次接口请求，每次定时任务执行，每次mq消息接收
 * 开放度不高，增加方法时注意根据方法维度判断添加在action级别还是父类project级别
 * @author jiaxz
 * @since 2023-01-05
 */
public interface ActionContext extends ProjectContext {
    /**
     * get send prize context
     *
     * @return send prize context
     */
    SendPrizeContext getSendPrizeContext();

    /**
     * get context value by key
     *
     * @param key context key
     * @return context value
     */
    Object getValue(String key);

    /**
     * set context value
     *
     * @param key   context key
     * @param value context value
     */
    void setValue(String key, Object value);

    String getPlaywayId();

    String getActionId();
}
