package cn.com.duiba.galaxy.sdk.api.pay;

import cn.com.duiba.galaxy.sdk.api.base.AutowiredApi;
import cn.com.duiba.galaxy.sdk.api.pay.third.api.AbcPayApi;
import cn.com.duiba.galaxy.sdk.api.pay.third.api.AliPayApi;
import cn.com.duiba.galaxy.sdk.api.pay.third.api.BocPayApi;
import cn.com.duiba.galaxy.sdk.api.pay.third.api.CcbPayApi;
import cn.com.duiba.galaxy.sdk.api.pay.third.api.CebXykPayApi;
import cn.com.duiba.galaxy.sdk.api.pay.third.api.CiticPayApi;
import cn.com.duiba.galaxy.sdk.api.pay.third.api.GdhxPayApi;
import cn.com.duiba.galaxy.sdk.api.pay.third.api.IcbcElifePayApi;
import cn.com.duiba.galaxy.sdk.api.pay.third.api.IcbcPayApi;
import cn.com.duiba.galaxy.sdk.api.pay.third.api.UnionPayApi;
import cn.com.duiba.galaxy.sdk.api.pay.third.api.WxPayApi;

/**
 * 支付服务
 *
 * @author 刘佳辉
 * @since 2022/12/8
 */
public interface PayApi extends AutowiredApi {

    /**
     * 微信支付 todo 未测试
     *
     * @return {@link WxPayApi}
     */
    WxPayApi getWxPayApi();

    /**
     * 支付宝支付 todo 未测试
     *
     * @return {@link AliPayApi}
     */
    AliPayApi getAliPayApi();

    /**
     * 中国银行支付 todo 未测试
     *
     * @return {@link BocPayApi}
     */
    BocPayApi getBocPayApi();

    /**
     * 农行支付 todo 未测试
     *
     * @return {@link AbcPayApi}
     */
    AbcPayApi getAbcPayApi();

    /**
     * 建行支付 todo 未测试
     *
     * @return {@link CcbPayApi}
     */
    CcbPayApi getCcbPayApi();

    /**
     * 中信银行支付 todo 未测试
     *
     * @return {@link CiticPayApi}
     */
    CiticPayApi getCiticPayApi();

    /**
     * 工行e支付H5 todo 未测试
     *
     * @return {@link IcbcPayApi}
     */
    IcbcPayApi getIcbcPayApi();

    /**
     * 工行e生活支付（app端 && 微信小程序端） todo 未测试
     *
     * @return {@link IcbcElifePayApi}
     */
    IcbcElifePayApi getIcbcElifePayApi();

    /**
     * 浙江银联支付 todo 未测试
     *
     * @return {@link UnionPayApi}
     */
    UnionPayApi getUnionPayApi();

    /**
     * 中国光大银行信用卡中心支付 todo 未测试
     *
     * @return {@link CebXykPayApi}
     */
    CebXykPayApi getCebXykPayApi();

    /**
     * 广东华兴银行支付 todo 未测试
     *
     * @return {@link GdhxPayApi}
     */
    GdhxPayApi getGdhxPayApi();
}
