package cn.com.duiba.galaxy.sdk.apiextra;


import cn.com.duiba.galaxy.sdk.api.base.Api;
import cn.com.duiba.galaxy.sdk.component.bindphone.data.SMSValidateRequestDataNew;
import cn.com.duiba.galaxy.sdk.component.bindphone.data.SMSValidateResponseDataNew;

/**
 * 短信验证码Api
 */
public interface SMSValidateApi extends Api {

    /**
     * 发送验证码
     *
     * 验证码只要在重试范围内，就可以重新生成并发送,以最新生成的验证码为准进行验证，旧验证码失效。
     *
     * @param data 具体传参数见：{@link SMSValidateRequestDataNew}
     * @return
     */
    SMSValidateResponseDataNew sendValidateCode(SMSValidateRequestDataNew data);

    /**
     * 校验验证码是否通过
     * 判断在有效的时间段内是否存在匹配的验证码
     * 校验通过后直接当前验证码直接失效
     *
     * @param groupName      分组名称（自定义 根据业务区分，不同业务之间保持不同即可）
     * @param phoneNumber  手机号码
     * @param code         验证码
     * @return
     */
    boolean checkValidateCode(String groupName, String phoneNumber, String code);

}
