package cn.com.duiba.galaxy.sdk.component;

import cn.com.duiba.galaxy.sdk.component.bindphone.BindPhoneComponentDefault;
import cn.com.duiba.galaxy.sdk.component.carousel.CarouselComponentAction;
import cn.com.duiba.galaxy.sdk.component.checkin.CheckinComponentActionDefault;
import cn.com.duiba.galaxy.sdk.component.drawprize.DrawPrizeComponentActionDefault;
import cn.com.duiba.galaxy.sdk.component.inviteassist.InviteAssistComponentActionDefault;
import cn.com.duiba.galaxy.sdk.component.rank.RankComponentActionDefault;
import cn.com.duiba.galaxy.sdk.component.task.TaskComponentActionDefault;

/**
 * @author liujiahui
 * @since 2021/11/30
 */
public enum ComponentTypeEnum {


    TASK("task", "任务组件", TaskComponentActionDefault.class),

//    SHARE("share", "分享组件"),
    INVITEASSIST("inviteAssist", "邀请助力组件", InviteAssistComponentActionDefault.class),
//    EXCHANGE("exchange", "兑换组件"),
//    PERIOD("period", "有效期组件"),
    CHECKIN("checkin", "签到组件", CheckinComponentActionDefault.class),
    RANK("rank", "排行榜组件", RankComponentActionDefault.class),
    //    GRADE("grade", "等级组件"),
//    COUNTDOWN("countdown", "倒计时组件"),
    BINDPHONE("bindPhone", "绑定手机号组件", BindPhoneComponentDefault.class),
//    NEWGUIDE("newguide", "新手引导组件"),
//
//    COLLECTSP("collectsp", "道具收集组件"),
    CAROUSEL("carousel", "轮播组件", CarouselComponentAction.class),
    DRAWPRIZE("drawPrize", "抽奖组件", DrawPrizeComponentActionDefault.class),
//    PARTICIPATE("participate", "参与组件"),
//    ANSWER("answer", "答题组件"),
//    TMRAWARD("tmraward", "明日奖励组件"),
//    TEAM("team", "队伍组件"),
//    TIMING("timing", "计时器组件"),
//    COLLECTAWARD("collectaward", "收集条件出奖组件"),
//    KEYWORDCHECK("keywordcheck", "关键词检查组件");
    ;

    private String type;
    private String name;
    private Class<?> defaultImpl;


    ComponentTypeEnum(String type, String name, Class<?> defaultImpl) {
        this.type = type;
        this.name = name;
        this.defaultImpl = defaultImpl;
    }

    public String getType() {
        return type;
    }


    public static ComponentTypeEnum getByType(String type) {
        for (ComponentTypeEnum value : ComponentTypeEnum.values()) {
            if (value.type.equals(type)) {
                return value;
            }
        }
        return null;
    }

    public Class<?> getDefaultImpl() {
        return defaultImpl;
    }
}
