package cn.com.duiba.galaxy.sdk.component;

/**
 * @program: projectx
 * @description: 组件限制 - 时间粒度枚举类
 * @author: Simba
 * @create: 2021-02-24 13:50
 **/
public enum TimeUnitEnum {
    NO_LIMIT(0, "不限制"),

    DAY(1, "日"),

    WEEK(2, "周"),

    MONTH(3, "月"),

    FOREVER(4, "永久"),

    CUSTOM(5, "自定义"),

    ;

    private int type;

    private String desc;

    TimeUnitEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static TimeUnitEnum toEnum(int type) {
        for (TimeUnitEnum p : values()) {
            if (p.type == type) {
                return p;
            }
        }
        return null;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

}
