package cn.com.duiba.galaxy.sdk.component.drawprize.dto;

import cn.com.duiba.galaxy.sdk.component.drawprize.enums.DrawPrizeTypeEnum;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 抽奖结果
 *
 * @author fangxiaorun
 * @date 2023/02/06
 */
@Getter
@Setter
public class DrawPrizeOptionResult {
    /**
     * 出奖类型{@link DrawPrizeTypeEnum#getCode()}
     */
    private Integer drawType;

    /**
     * 出奖类型为奖池抽奖时，该字段不为空，为关联的奖池出奖规则ID
     */
    private String ruleId;

    /**
     * 出奖类型为道具时，该字段不为空，为关联的道具ID
     */
    private String spId;

    /**
     * 奖品详情列表
     */
    private List<SendPrizeResult> options;
}
