package cn.com.duiba.galaxy.sdk.component.rank;

import cn.com.duiba.galaxy.common.exception.BizRuntimeException;
import cn.com.duiba.galaxy.sdk.PlatformSdkErrorEnum;
import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.sdk.api.user.inner.ConsumerExtra;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author jiaxz
 * @since 2023-01-18
 */
public class RankComponentActionDefault extends RankComponentAction {

    private final String componentId;

    public RankComponentActionDefault(String componentId) {
        this.componentId = componentId;
    }

    /**
     * 查询排行榜信息
     *
     * @param api
     * @return
     */
    @Override
    @CustomRequestAction(id = "queryRankInfo", desc = "查询排行榜信息")
    public LeaderboardArchiveVo queryRankInfo(UserRequestApi api) {
        // phaseType   0 获取当前期次 -1 获取上一期次
        Integer phaseType = api.getIntegerParameterCheckNull("phaseType");


        LeaderboardArchiveVo leaderboardArchiveVo=null;
        if (phaseType.equals(0)) {
            leaderboardArchiveVo = api.getComponentApi().getRankApi().queryArchive(componentId);
        }
        if (phaseType.equals(-1)) {
            leaderboardArchiveVo = api.getComponentApi().getRankApi().queryPreviousArchive(componentId);
        }


        return leaderboardArchiveVo;
    }

    /**
     * 查询排行榜
     *
     * @param api
     * @return
     */
    @Override
    @CustomRequestAction(id = "queryRanking", desc = "查询排行榜")
    public List<RankingVo> queryRanking(UserRequestApi api) {
        Integer topN = api.getIntegerParameterCheckNull("topN");
        if (topN == null || topN > 500) {
            throw new BizRuntimeException(PlatformSdkErrorEnum.PARAM_ERROR);
        }
        // phaseType   0 获取当前期次 -1 获取上一期次
        Integer phaseType = api.getIntegerParameterCheckNull("phaseType");
        List<Ranking> currentTopN = null;
        if (phaseType.equals(0)) {
            currentTopN = api.getComponentApi().getRankApi().getCurrentTopN(componentId, topN);
        }
        if (phaseType.equals(1)) {
            currentTopN = api.getComponentApi().getRankApi().getPreviousTopN(componentId, topN);
        }

        if (currentTopN == null || currentTopN.isEmpty()) {
            return new ArrayList<>();
        }

        List<Long> userIds = currentTopN.stream().map(Ranking::getUserId).collect(Collectors.toList());
        List<ConsumerExtra> consumerExtras = api.getConsumerApi().listConsumerExtraByConsumerIds(userIds);
        Map<Long, ConsumerExtra> consumerMap = consumerExtras.stream().collect(Collectors.toMap(ConsumerExtra::getConsumerId, Function.identity()));

        List<RankingVo> list = new ArrayList<>();
        for (int i = 0; i < currentTopN.size(); i++) {
            Ranking ranking = currentTopN.get(i);
            RankingVo rankingVo = new RankingVo();
            rankingVo.setIndex(i + 1);
            rankingVo.setScore(ranking.getMaxScore());
            rankingVo.setUserId(ranking.getUserId());
            ConsumerExtra consumerExtra = consumerMap.get(ranking.getUserId());
            if (consumerExtra != null) {
                rankingVo.setAvatar(consumerExtra.getAvatar());
                rankingVo.setNickname(consumerExtra.getNickname());
            }
            list.add(rankingVo);
        }

        return list;
    }


    /**
     * 查询当前用户排行榜信息
     *
     * @param api
     * @return
     */
    @Override
    @CustomRequestAction(id = "queryUserRanking", desc = "查询当前用户排行榜信息")
    public RankingVo queryUserRanking(UserRequestApi api) {

        // phaseType   0 获取当前期次 -1 获取上一期次
        Integer phaseType = api.getIntegerParameterCheckNull("phaseType");
        Ranking myRanking = null;
        if (phaseType.equals(0)) {
            myRanking = api.getComponentApi().getRankApi().getCurrentRankInfo(componentId, api.getUserId());
        }
        if (phaseType.equals(1)) {
            myRanking = api.getComponentApi().getRankApi().getPreviousRankInfo(componentId, api.getUserId());
        }

        if (myRanking == null) {
            return null;
        }

        Integer myRank = api.getComponentApi().getRankApi().getCurrentRanking(componentId, api.getUserId());

        List<ConsumerExtra> consumerExtras = api.getConsumerApi().listConsumerExtraByConsumerIds(Collections.singletonList(api.getUserId()));
        Map<Long, ConsumerExtra> consumerMap = consumerExtras.stream().collect(Collectors.toMap(ConsumerExtra::getConsumerId, Function.identity()));

        RankingVo rankingVo = new RankingVo();
        rankingVo.setIndex(myRank);
        rankingVo.setScore(myRanking.getMaxScore());
        rankingVo.setUserId(api.getUserId());
        ConsumerExtra consumerExtra = consumerMap.get(api.getUserId());
        if (consumerExtra != null) {
            rankingVo.setAvatar(consumerExtra.getAvatar());
            rankingVo.setNickname(consumerExtra.getNickname());
        }

        return rankingVo;
    }


    /**
     * 查询当前排行榜是否最后一期
     *
     * @param api
     * @return
     */
    @Override
    @CustomRequestAction(id = "queryLastPhaseAction", desc = "查询当前排行榜是否最后一期")
    public Boolean queryLastPhaseAction(UserRequestApi api) {
        return api.getComponentApi().getRankApi().queryLastPhaseAction(componentId);
    }
}
