package cn.com.duiba.galaxy.sdk.component.rank;

import java.util.Date;

/**
 * 排行榜
 *
 * @author zhangdaqing
 * @date 2023/01/30
 */
public interface Ranking {


    /**
     * id
     *
     * @return {@link Long}
     */
    public Long getId();


    /**
     * 项目id
     *
     * @return {@link Long}
     */
    public Long getProjectId();


    /**
     * 类型
     *
     * @return {@link String}
     */
    public String getType();


    /**
     * 用户id
     *
     * @return {@link Long}
     */
    public Long getUserId();


    /**
     * 最高分数
     *
     * @return {@link Integer}
     */
    public Integer getMaxScore();


    /**
     * 是否发放奖品
     *
     * @return {@link Boolean}
     */
    public Boolean getSendPrize();


    /**
     * 奖品id
     *
     * @return {@link String}
     */
    public String getPrizeId();


    /**
     * 发奖时间
     *
     * @return {@link Date}
     */
    public Date getSendPrizeTime();


    /**
     * 开始时间
     *
     * @return {@link Date}
     */
    public Date getGmtCreate();


    /**
     * 修改时间
     *
     * @return {@link Date}
     */
    public Date getGmtModified();

}
