package cn.com.duiba.galaxy.sdk.component.rank.dto;

import lombok.Getter;
import lombok.Setter;

/**
 * @author jiaxz
 * @since 2023-01-17
 * 数据保存参考 OptionJsonParam
 * 数据响应参考
 */
@Getter
@Setter
public class RankPrize {

    Long id;


    /** 奖项名称 */
    String name;


    /**
     * 奖项类型
     * @see OptionTypeEnum#getCode()
     */
    private Integer type;


    /**
     * 第三方商品id
     * 注意：这里的itemId区别于积分商城的itemId，这里泛指所关联的第三方商品id；
     */
    private String itemId;


    /** 已获得奖项图片 */
    private String icon;


    /** 未获得奖项图片 */
    private String icon2;


    /** 总库存  道具此项不填写可以不限制 但是如果填写了且存在已使用道具数量，必须已使用的道具数量 */
    Long totalStock;


    /** 奖项ID */
    Long prizeId;


    /**
     * 商品来源
     */
    private Integer bizType;


    /** 排序 */
    Integer pos ;


    /** 排行榜名次,存入奖项的临时字段 */
    String rank;


}
