package cn.com.duiba.galaxy.sdk.util;

import cn.com.duiba.galaxy.sdk.api.base.Api;
import cn.com.duiba.galaxy.sdk.component.bindphone.data.SendDingMsgResult;
import cn.com.duiba.galaxy.sdk.component.bindphone.data.SmsSendReceipt;

import java.util.List;

/**
 * 通知API
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: NotifyApi.java , v 0.1 2020-01-08 11:20 上午 ZhouFeng Exp $
 */
public interface NotifyApi extends Api {

    /**
     * 发送邮件接口
     * 调用者请控制好发送速率
     *
     * @param mailMessage
     */
    void sendMail(MailMessage mailMessage);


    /**
     * 发送短信
     * 有新的短信模板时，需要通知中台增加新的短信模板
     *
     * @param phoneNumber 手机号
     * @param content     短信内容
     * @return
     */
    SmsSendReceipt sendSms(String phoneNumber, String content);


    /**
     * 批量发送短信
     * 有新的短信模板时，需要通知中台增加新的短信模板
     *
     * @param phoneNumbers 手机号列表
     * @param content      短信内容
     * @return
     */
    List<SmsSendReceipt> batchSendSms(List<String> phoneNumbers, String content);


    /**
     * 根据机器人token发送自定义机器人文本消息
     *
     * @param token      机器人token
     * @param title      首屏会话透出的展示内容
     * @param content    消息内容
     * @param atAdminIds 需要@的人列表  列表为空时,通知所有人
     * @return
     */
    SendDingMsgResult sendTextRobotByToken(String token, String title, String content, List<Long> atAdminIds);

}
